package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsListConfigItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 配置组信息
 */
@ApiModel(description = "配置组信息")

@JsonInclude(NON_NULL)
public class MsGetConfigGroup {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("configGroupCode")
  private String configGroupCode = null;

  @JsonProperty("configGroupName")
  private String configGroupName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("editFlag")
  private Integer editFlag = null;

  @JsonProperty("configGroupStatus")
  private Integer configGroupStatus = null;

  @JsonProperty("configGroupRange")
  private Integer configGroupRange = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("defaultConfigFlag")
  private Integer defaultConfigFlag = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("configItems")
  private List<MsListConfigItem> configItems = new ArrayList<MsListConfigItem>();

  @JsonIgnore
  public MsGetConfigGroup id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 数据主键
   * @return id
  **/
  @ApiModelProperty(value = "数据主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGetConfigGroup configGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
    return this;
  }

   /**
   * 配置组代码(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)
   * @return configGroupCode
  **/
  @ApiModelProperty(value = "配置组代码(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)")
  public String getConfigGroupCode() {
    return configGroupCode;
  }

  public void setConfigGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
  }

  @JsonIgnore
  public MsGetConfigGroup configGroupName(String configGroupName) {
    this.configGroupName = configGroupName;
    return this;
  }

   /**
   * 配置组名称
   * @return configGroupName
  **/
  @ApiModelProperty(value = "配置组名称")
  public String getConfigGroupName() {
    return configGroupName;
  }

  public void setConfigGroupName(String configGroupName) {
    this.configGroupName = configGroupName;
  }

  @JsonIgnore
  public MsGetConfigGroup purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsGetConfigGroup editFlag(Integer editFlag) {
    this.editFlag = editFlag;
    return this;
  }

   /**
   * 编辑标记(0:可以编辑删除,1:可编辑不能删除,2:不可编辑和删除)
   * @return editFlag
  **/
  @ApiModelProperty(value = "编辑标记(0:可以编辑删除,1:可编辑不能删除,2:不可编辑和删除)")
  public Integer getEditFlag() {
    return editFlag;
  }

  public void setEditFlag(Integer editFlag) {
    this.editFlag = editFlag;
  }

  @JsonIgnore
  public MsGetConfigGroup configGroupStatus(Integer configGroupStatus) {
    this.configGroupStatus = configGroupStatus;
    return this;
  }

   /**
   * 配置组状态(0:正常,1:停用)
   * @return configGroupStatus
  **/
  @ApiModelProperty(value = "配置组状态(0:正常,1:停用)")
  public Integer getConfigGroupStatus() {
    return configGroupStatus;
  }

  public void setConfigGroupStatus(Integer configGroupStatus) {
    this.configGroupStatus = configGroupStatus;
  }

  @JsonIgnore
  public MsGetConfigGroup configGroupRange(Integer configGroupRange) {
    this.configGroupRange = configGroupRange;
    return this;
  }

   /**
   * 公司生效范围(0:集团,1:企业)
   * @return configGroupRange
  **/
  @ApiModelProperty(value = "公司生效范围(0:集团,1:企业)")
  public Integer getConfigGroupRange() {
    return configGroupRange;
  }

  public void setConfigGroupRange(Integer configGroupRange) {
    this.configGroupRange = configGroupRange;
  }

  @JsonIgnore
  public MsGetConfigGroup companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 企业ID
   * @return companyId
  **/
  @ApiModelProperty(value = "企业ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsGetConfigGroup defaultConfigFlag(Integer defaultConfigFlag) {
    this.defaultConfigFlag = defaultConfigFlag;
    return this;
  }

   /**
   * 是否为默认配置(0:否,1:是)
   * @return defaultConfigFlag
  **/
  @ApiModelProperty(value = "是否为默认配置(0:否,1:是)")
  public Integer getDefaultConfigFlag() {
    return defaultConfigFlag;
  }

  public void setDefaultConfigFlag(Integer defaultConfigFlag) {
    this.defaultConfigFlag = defaultConfigFlag;
  }

  @JsonIgnore
  public MsGetConfigGroup createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsGetConfigGroup createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsGetConfigGroup createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsGetConfigGroup updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 修改人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "修改人ID")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsGetConfigGroup updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 修改人名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "修改人名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsGetConfigGroup updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 修改时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "修改时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsGetConfigGroup configItems(List<MsListConfigItem> configItems) {
    this.configItems = configItems;
    return this;
  }

  public MsGetConfigGroup addConfigItemsItem(MsListConfigItem configItemsItem) {
    this.configItems.add(configItemsItem);
    return this;
  }

   /**
   * 配置项列表
   * @return configItems
  **/
  @ApiModelProperty(value = "配置项列表")
  public List<MsListConfigItem> getConfigItems() {
    return configItems;
  }

  public void setConfigItems(List<MsListConfigItem> configItems) {
    this.configItems = configItems;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetConfigGroup getConfigGroup = (MsGetConfigGroup) o;
    return Objects.equals(this.id, getConfigGroup.id) &&
        Objects.equals(this.configGroupCode, getConfigGroup.configGroupCode) &&
        Objects.equals(this.configGroupName, getConfigGroup.configGroupName) &&
        Objects.equals(this.purchaserName, getConfigGroup.purchaserName) &&
        Objects.equals(this.editFlag, getConfigGroup.editFlag) &&
        Objects.equals(this.configGroupStatus, getConfigGroup.configGroupStatus) &&
        Objects.equals(this.configGroupRange, getConfigGroup.configGroupRange) &&
        Objects.equals(this.companyId, getConfigGroup.companyId) &&
        Objects.equals(this.defaultConfigFlag, getConfigGroup.defaultConfigFlag) &&
        Objects.equals(this.createUserId, getConfigGroup.createUserId) &&
        Objects.equals(this.createUserName, getConfigGroup.createUserName) &&
        Objects.equals(this.createTime, getConfigGroup.createTime) &&
        Objects.equals(this.updateUserId, getConfigGroup.updateUserId) &&
        Objects.equals(this.updateUserName, getConfigGroup.updateUserName) &&
        Objects.equals(this.updateTime, getConfigGroup.updateTime) &&
        Objects.equals(this.configItems, getConfigGroup.configItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, configGroupCode, configGroupName, purchaserName, editFlag, configGroupStatus, configGroupRange, companyId, defaultConfigFlag, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime, configItems);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetConfigGroup {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    configGroupCode: ").append(toIndentedString(configGroupCode)).append("\n");
    sb.append("    configGroupName: ").append(toIndentedString(configGroupName)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    editFlag: ").append(toIndentedString(editFlag)).append("\n");
    sb.append("    configGroupStatus: ").append(toIndentedString(configGroupStatus)).append("\n");
    sb.append("    configGroupRange: ").append(toIndentedString(configGroupRange)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    defaultConfigFlag: ").append(toIndentedString(defaultConfigFlag)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    configItems: ").append(toIndentedString(configItems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
