package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 根据条件获取配置组请求
 */
@ApiModel(description = "根据条件获取配置组请求")

@JsonInclude(NON_NULL)
public class MsGetConfigGroupByParamsRequest {
  @JsonProperty("configGroupCode")
  private String configGroupCode = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsGetConfigGroupByParamsRequest configGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
    return this;
  }

   /**
   * 配置组ID
   * @return configGroupCode
  **/
  @ApiModelProperty(value = "配置组ID")
  public String getConfigGroupCode() {
    return configGroupCode;
  }

  public void setConfigGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
  }

  @JsonIgnore
  public MsGetConfigGroupByParamsRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsGetConfigGroupByParamsRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetConfigGroupByParamsRequest getConfigGroupByParamsRequest = (MsGetConfigGroupByParamsRequest) o;
    return Objects.equals(this.configGroupCode, getConfigGroupByParamsRequest.configGroupCode) &&
        Objects.equals(this.companyId, getConfigGroupByParamsRequest.companyId) &&
        Objects.equals(this.userInfo, getConfigGroupByParamsRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configGroupCode, companyId, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetConfigGroupByParamsRequest {\n");
    
    sb.append("    configGroupCode: ").append(toIndentedString(configGroupCode)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
