package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取配置组请求
 */
@ApiModel(description = "获取配置组请求")

@JsonInclude(NON_NULL)
public class MsGetConfigGroupRequest {
  @JsonProperty("configGroupId")
  private Long configGroupId = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsGetConfigGroupRequest configGroupId(Long configGroupId) {
    this.configGroupId = configGroupId;
    return this;
  }

   /**
   * 配置组ID
   * @return configGroupId
  **/
  @ApiModelProperty(value = "配置组ID")
  public Long getConfigGroupId() {
    return configGroupId;
  }

  public void setConfigGroupId(Long configGroupId) {
    this.configGroupId = configGroupId;
  }

  @JsonIgnore
  public MsGetConfigGroupRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetConfigGroupRequest getConfigGroupRequest = (MsGetConfigGroupRequest) o;
    return Objects.equals(this.configGroupId, getConfigGroupRequest.configGroupId) &&
        Objects.equals(this.userInfo, getConfigGroupRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configGroupId, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetConfigGroupRequest {\n");
    
    sb.append("    configGroupId: ").append(toIndentedString(configGroupId)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
