package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取自定义列配置请求
 */
@ApiModel(description = "获取自定义列配置请求")

@JsonInclude(NON_NULL)
public class MsGetCustomColumnRequest {
  @JsonProperty("moduleNo")
  private Integer moduleNo = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonIgnore
  public MsGetCustomColumnRequest moduleNo(Integer moduleNo) {
    this.moduleNo = moduleNo;
    return this;
  }

   /**
   * 模块编号 0-默认, 1-配单模块
   * @return moduleNo
  **/
  @ApiModelProperty(value = "模块编号 0-默认, 1-配单模块")
  public Integer getModuleNo() {
    return moduleNo;
  }

  public void setModuleNo(Integer moduleNo) {
    this.moduleNo = moduleNo;
  }

  @JsonIgnore
  public MsGetCustomColumnRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetCustomColumnRequest getCustomColumnRequest = (MsGetCustomColumnRequest) o;
    return Objects.equals(this.moduleNo, getCustomColumnRequest.moduleNo) &&
        Objects.equals(this.purchaserGroupId, getCustomColumnRequest.purchaserGroupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(moduleNo, purchaserGroupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetCustomColumnRequest {\n");
    
    sb.append("    moduleNo: ").append(toIndentedString(moduleNo)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
