package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 商品信息请求
 */
@ApiModel(description = "商品信息请求")

@JsonInclude(NON_NULL)
public class MsGetGoodsInfoRequest {
  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("goodsTaxShort")
  private String goodsTaxShort = null;

  @JsonIgnore
  public MsGetGoodsInfoRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 购方集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "购方集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsGetGoodsInfoRequest goodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
    return this;
  }

   /**
   * 税编简称
   * @return goodsTaxShort
  **/
  @ApiModelProperty(value = "税编简称")
  public String getGoodsTaxShort() {
    return goodsTaxShort;
  }

  public void setGoodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetGoodsInfoRequest getGoodsInfoRequest = (MsGetGoodsInfoRequest) o;
    return Objects.equals(this.purchaserGroupId, getGoodsInfoRequest.purchaserGroupId) &&
        Objects.equals(this.goodsTaxShort, getGoodsInfoRequest.goodsTaxShort);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserGroupId, goodsTaxShort);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetGoodsInfoRequest {\n");
    
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    goodsTaxShort: ").append(toIndentedString(goodsTaxShort)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
