package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 组织树请求
 */
@ApiModel(description = "组织树请求")

@JsonInclude(NON_NULL)
public class MsGetOrgInfoTreeRequest {
  @JsonProperty("configGroupCode")
  private String configGroupCode = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsGetOrgInfoTreeRequest configGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
    return this;
  }

   /**
   * 配置组代码(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)
   * @return configGroupCode
  **/
  @ApiModelProperty(value = "配置组代码(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)")
  public String getConfigGroupCode() {
    return configGroupCode;
  }

  public void setConfigGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
  }

  @JsonIgnore
  public MsGetOrgInfoTreeRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOrgInfoTreeRequest getOrgInfoTreeRequest = (MsGetOrgInfoTreeRequest) o;
    return Objects.equals(this.configGroupCode, getOrgInfoTreeRequest.configGroupCode) &&
        Objects.equals(this.userInfo, getOrgInfoTreeRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configGroupCode, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOrgInfoTreeRequest {\n");
    
    sb.append("    configGroupCode: ").append(toIndentedString(configGroupCode)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
