package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取规则配置数据的请求
 */
@ApiModel(description = "获取规则配置数据的请求")

@JsonInclude(NON_NULL)
public class MsGetRuleContentDataByServiceRequest {
  @JsonProperty("triggerService")
  private String triggerService = null;

  @JsonProperty("ruleGroupCode")
  private String ruleGroupCode = null;

  @JsonProperty("triggerPoint")
  private String triggerPoint = null;

  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("internalOrgId")
  private List<String> internalOrgId = new ArrayList<String>();

  @JsonIgnore
  public MsGetRuleContentDataByServiceRequest triggerService(String triggerService) {
    this.triggerService = triggerService;
    return this;
  }

   /**
   * 调用方服务名称
   * @return triggerService
  **/
  @ApiModelProperty(value = "调用方服务名称")
  public String getTriggerService() {
    return triggerService;
  }

  public void setTriggerService(String triggerService) {
    this.triggerService = triggerService;
  }

  @JsonIgnore
  public MsGetRuleContentDataByServiceRequest ruleGroupCode(String ruleGroupCode) {
    this.ruleGroupCode = ruleGroupCode;
    return this;
  }

   /**
   * 规则组代码
   * @return ruleGroupCode
  **/
  @ApiModelProperty(value = "规则组代码")
  public String getRuleGroupCode() {
    return ruleGroupCode;
  }

  public void setRuleGroupCode(String ruleGroupCode) {
    this.ruleGroupCode = ruleGroupCode;
  }

  @JsonIgnore
  public MsGetRuleContentDataByServiceRequest triggerPoint(String triggerPoint) {
    this.triggerPoint = triggerPoint;
    return this;
  }

   /**
   * 触发点
   * @return triggerPoint
  **/
  @ApiModelProperty(value = "触发点")
  public String getTriggerPoint() {
    return triggerPoint;
  }

  public void setTriggerPoint(String triggerPoint) {
    this.triggerPoint = triggerPoint;
  }

  @JsonIgnore
  public MsGetRuleContentDataByServiceRequest groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团Id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团Id")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsGetRuleContentDataByServiceRequest internalOrgId(List<String> internalOrgId) {
    this.internalOrgId = internalOrgId;
    return this;
  }

  public MsGetRuleContentDataByServiceRequest addInternalOrgIdItem(String internalOrgIdItem) {
    this.internalOrgId.add(internalOrgIdItem);
    return this;
  }

   /**
   * 内部组织Id
   * @return internalOrgId
  **/
  @ApiModelProperty(value = "内部组织Id")
  public List<String> getInternalOrgId() {
    return internalOrgId;
  }

  public void setInternalOrgId(List<String> internalOrgId) {
    this.internalOrgId = internalOrgId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRuleContentDataByServiceRequest getRuleContentDataByServiceRequest = (MsGetRuleContentDataByServiceRequest) o;
    return Objects.equals(this.triggerService, getRuleContentDataByServiceRequest.triggerService) &&
        Objects.equals(this.ruleGroupCode, getRuleContentDataByServiceRequest.ruleGroupCode) &&
        Objects.equals(this.triggerPoint, getRuleContentDataByServiceRequest.triggerPoint) &&
        Objects.equals(this.groupId, getRuleContentDataByServiceRequest.groupId) &&
        Objects.equals(this.internalOrgId, getRuleContentDataByServiceRequest.internalOrgId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(triggerService, ruleGroupCode, triggerPoint, groupId, internalOrgId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRuleContentDataByServiceRequest {\n");
    
    sb.append("    triggerService: ").append(toIndentedString(triggerService)).append("\n");
    sb.append("    ruleGroupCode: ").append(toIndentedString(ruleGroupCode)).append("\n");
    sb.append("    triggerPoint: ").append(toIndentedString(triggerPoint)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    internalOrgId: ").append(toIndentedString(internalOrgId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
