package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取规则组的请求
 */
@ApiModel(description = "获取规则组的请求")

@JsonInclude(NON_NULL)
public class MsGetRuleGroupRequest {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("triggerPoint")
  private String triggerPoint = null;

  @JsonProperty("ruleGroupCode")
  private String ruleGroupCode = null;

  @JsonProperty("defaultConfig")
  private String defaultConfig = null;

  @JsonProperty("ruleGroupStatus")
  private Integer ruleGroupStatus = null;

  @JsonProperty("ruleGroupName")
  private String ruleGroupName = null;

  @JsonIgnore
  public MsGetRuleGroupRequest id(String id) {
    this.id = id;
    return this;
  }

   /**
   * 规则组Id
   * @return id
  **/
  @ApiModelProperty(value = "规则组Id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGetRuleGroupRequest groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团Id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团Id")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsGetRuleGroupRequest triggerPoint(String triggerPoint) {
    this.triggerPoint = triggerPoint;
    return this;
  }

   /**
   * 规则组触发点
   * @return triggerPoint
  **/
  @ApiModelProperty(value = "规则组触发点")
  public String getTriggerPoint() {
    return triggerPoint;
  }

  public void setTriggerPoint(String triggerPoint) {
    this.triggerPoint = triggerPoint;
  }

  @JsonIgnore
  public MsGetRuleGroupRequest ruleGroupCode(String ruleGroupCode) {
    this.ruleGroupCode = ruleGroupCode;
    return this;
  }

   /**
   * 规则组代码
   * @return ruleGroupCode
  **/
  @ApiModelProperty(value = "规则组代码")
  public String getRuleGroupCode() {
    return ruleGroupCode;
  }

  public void setRuleGroupCode(String ruleGroupCode) {
    this.ruleGroupCode = ruleGroupCode;
  }

  @JsonIgnore
  public MsGetRuleGroupRequest defaultConfig(String defaultConfig) {
    this.defaultConfig = defaultConfig;
    return this;
  }

   /**
   * 默认配置
   * @return defaultConfig
  **/
  @ApiModelProperty(value = "默认配置")
  public String getDefaultConfig() {
    return defaultConfig;
  }

  public void setDefaultConfig(String defaultConfig) {
    this.defaultConfig = defaultConfig;
  }

  @JsonIgnore
  public MsGetRuleGroupRequest ruleGroupStatus(Integer ruleGroupStatus) {
    this.ruleGroupStatus = ruleGroupStatus;
    return this;
  }

   /**
   * 规则启用状态
   * @return ruleGroupStatus
  **/
  @ApiModelProperty(value = "规则启用状态")
  public Integer getRuleGroupStatus() {
    return ruleGroupStatus;
  }

  public void setRuleGroupStatus(Integer ruleGroupStatus) {
    this.ruleGroupStatus = ruleGroupStatus;
  }

  @JsonIgnore
  public MsGetRuleGroupRequest ruleGroupName(String ruleGroupName) {
    this.ruleGroupName = ruleGroupName;
    return this;
  }

   /**
   * 规则组名称
   * @return ruleGroupName
  **/
  @ApiModelProperty(value = "规则组名称")
  public String getRuleGroupName() {
    return ruleGroupName;
  }

  public void setRuleGroupName(String ruleGroupName) {
    this.ruleGroupName = ruleGroupName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRuleGroupRequest getRuleGroupRequest = (MsGetRuleGroupRequest) o;
    return Objects.equals(this.id, getRuleGroupRequest.id) &&
        Objects.equals(this.groupId, getRuleGroupRequest.groupId) &&
        Objects.equals(this.triggerPoint, getRuleGroupRequest.triggerPoint) &&
        Objects.equals(this.ruleGroupCode, getRuleGroupRequest.ruleGroupCode) &&
        Objects.equals(this.defaultConfig, getRuleGroupRequest.defaultConfig) &&
        Objects.equals(this.ruleGroupStatus, getRuleGroupRequest.ruleGroupStatus) &&
        Objects.equals(this.ruleGroupName, getRuleGroupRequest.ruleGroupName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupId, triggerPoint, ruleGroupCode, defaultConfig, ruleGroupStatus, ruleGroupName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRuleGroupRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    triggerPoint: ").append(toIndentedString(triggerPoint)).append("\n");
    sb.append("    ruleGroupCode: ").append(toIndentedString(ruleGroupCode)).append("\n");
    sb.append("    defaultConfig: ").append(toIndentedString(defaultConfig)).append("\n");
    sb.append("    ruleGroupStatus: ").append(toIndentedString(ruleGroupStatus)).append("\n");
    sb.append("    ruleGroupName: ").append(toIndentedString(ruleGroupName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
