package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsPcfRuleGroupModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取规则组的内容
 */
@ApiModel(description = "获取规则组的内容")

@JsonInclude(NON_NULL)
public class MsGetRuleGroupResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsPcfRuleGroupModel> result = new ArrayList<MsPcfRuleGroupModel>();

  @JsonIgnore
  public MsGetRuleGroupResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetRuleGroupResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetRuleGroupResponse result(List<MsPcfRuleGroupModel> result) {
    this.result = result;
    return this;
  }

  public MsGetRuleGroupResponse addResultItem(MsPcfRuleGroupModel resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 规则组的内容
   * @return result
  **/
  @ApiModelProperty(value = "规则组的内容")
  public List<MsPcfRuleGroupModel> getResult() {
    return result;
  }

  public void setResult(List<MsPcfRuleGroupModel> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRuleGroupResponse getRuleGroupResponse = (MsGetRuleGroupResponse) o;
    return Objects.equals(this.code, getRuleGroupResponse.code) &&
        Objects.equals(this.message, getRuleGroupResponse.message) &&
        Objects.equals(this.result, getRuleGroupResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRuleGroupResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
