package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsTurnOutItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取转出配置返回结果
 */
@ApiModel(description = "获取转出配置返回结果")

@JsonInclude(NON_NULL)
public class MsGetTurnOutConfigResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("TurnOutMust")
  private List<MsTurnOutItem> turnOutMust = new ArrayList<MsTurnOutItem>();

  @JsonProperty("TurnOutTypeConfig")
  private List<MsTurnOutItem> turnOutTypeConfig = new ArrayList<MsTurnOutItem>();

  @JsonIgnore
  public MsGetTurnOutConfigResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetTurnOutConfigResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回结果
   * @return message
  **/
  @ApiModelProperty(value = "返回结果")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetTurnOutConfigResponse turnOutMust(List<MsTurnOutItem> turnOutMust) {
    this.turnOutMust = turnOutMust;
    return this;
  }

  public MsGetTurnOutConfigResponse addTurnOutMustItem(MsTurnOutItem turnOutMustItem) {
    this.turnOutMust.add(turnOutMustItem);
    return this;
  }

   /**
   * 转出必填项
   * @return turnOutMust
  **/
  @ApiModelProperty(value = "转出必填项")
  public List<MsTurnOutItem> getTurnOutMust() {
    return turnOutMust;
  }

  public void setTurnOutMust(List<MsTurnOutItem> turnOutMust) {
    this.turnOutMust = turnOutMust;
  }

  @JsonIgnore
  public MsGetTurnOutConfigResponse turnOutTypeConfig(List<MsTurnOutItem> turnOutTypeConfig) {
    this.turnOutTypeConfig = turnOutTypeConfig;
    return this;
  }

  public MsGetTurnOutConfigResponse addTurnOutTypeConfigItem(MsTurnOutItem turnOutTypeConfigItem) {
    this.turnOutTypeConfig.add(turnOutTypeConfigItem);
    return this;
  }

   /**
   * 转出类型配置
   * @return turnOutTypeConfig
  **/
  @ApiModelProperty(value = "转出类型配置")
  public List<MsTurnOutItem> getTurnOutTypeConfig() {
    return turnOutTypeConfig;
  }

  public void setTurnOutTypeConfig(List<MsTurnOutItem> turnOutTypeConfig) {
    this.turnOutTypeConfig = turnOutTypeConfig;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetTurnOutConfigResponse getTurnOutConfigResponse = (MsGetTurnOutConfigResponse) o;
    return Objects.equals(this.code, getTurnOutConfigResponse.code) &&
        Objects.equals(this.message, getTurnOutConfigResponse.message) &&
        Objects.equals(this.turnOutMust, getTurnOutConfigResponse.turnOutMust) &&
        Objects.equals(this.turnOutTypeConfig, getTurnOutConfigResponse.turnOutTypeConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, turnOutMust, turnOutTypeConfig);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetTurnOutConfigResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    turnOutMust: ").append(toIndentedString(turnOutMust)).append("\n");
    sb.append("    turnOutTypeConfig: ").append(toIndentedString(turnOutTypeConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
