package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 商品信息请求
 */
@ApiModel(description = "商品信息请求")

@JsonInclude(NON_NULL)
public class MsGoodsInfoRequest {
  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsTaxShort")
  private String goodsTaxShort = null;

  @JsonProperty("taxBusinessType")
  private String taxBusinessType = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsGoodsInfoRequest goodsId(Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 商品主键（修改数据时需要）
   * @return goodsId
  **/
  @ApiModelProperty(value = "商品主键（修改数据时需要）")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }

  @JsonIgnore
  public MsGoodsInfoRequest goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsGoodsInfoRequest goodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
    return this;
  }

   /**
   * 税编简称
   * @return goodsTaxShort
  **/
  @ApiModelProperty(value = "税编简称")
  public String getGoodsTaxShort() {
    return goodsTaxShort;
  }

  public void setGoodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
  }

  @JsonIgnore
  public MsGoodsInfoRequest taxBusinessType(String taxBusinessType) {
    this.taxBusinessType = taxBusinessType;
    return this;
  }

   /**
   * 税编简称业务类型
   * @return taxBusinessType
  **/
  @ApiModelProperty(value = "税编简称业务类型")
  public String getTaxBusinessType() {
    return taxBusinessType;
  }

  public void setTaxBusinessType(String taxBusinessType) {
    this.taxBusinessType = taxBusinessType;
  }

  @JsonIgnore
  public MsGoodsInfoRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsInfoRequest goodsInfoRequest = (MsGoodsInfoRequest) o;
    return Objects.equals(this.goodsId, goodsInfoRequest.goodsId) &&
        Objects.equals(this.goodsName, goodsInfoRequest.goodsName) &&
        Objects.equals(this.goodsTaxShort, goodsInfoRequest.goodsTaxShort) &&
        Objects.equals(this.taxBusinessType, goodsInfoRequest.taxBusinessType) &&
        Objects.equals(this.userInfo, goodsInfoRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsId, goodsName, goodsTaxShort, taxBusinessType, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsInfoRequest {\n");
    
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsTaxShort: ").append(toIndentedString(goodsTaxShort)).append("\n");
    sb.append("    taxBusinessType: ").append(toIndentedString(taxBusinessType)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
