package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导入excel请求
 */
@ApiModel(description = "导入excel请求")

@JsonInclude(NON_NULL)
public class MsImportExcelRequest {
  @JsonProperty("ossUrl")
  private String ossUrl = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsImportExcelRequest ossUrl(String ossUrl) {
    this.ossUrl = ossUrl;
    return this;
  }

   /**
   * oss地址
   * @return ossUrl
  **/
  @ApiModelProperty(value = "oss地址")
  public String getOssUrl() {
    return ossUrl;
  }

  public void setOssUrl(String ossUrl) {
    this.ossUrl = ossUrl;
  }

  @JsonIgnore
  public MsImportExcelRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @ApiModelProperty(value = "")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportExcelRequest importExcelRequest = (MsImportExcelRequest) o;
    return Objects.equals(this.ossUrl, importExcelRequest.ossUrl) &&
        Objects.equals(this.userInfo, importExcelRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ossUrl, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportExcelRequest {\n");
    
    sb.append("    ossUrl: ").append(toIndentedString(ossUrl)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
