package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsImportGoodsDataRequest
 */

@JsonInclude(NON_NULL)
public class MsImportGoodsDataRequest {
  @JsonProperty("ossKey")
  private String ossKey = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsImportGoodsDataRequest ossKey(String ossKey) {
    this.ossKey = ossKey;
    return this;
  }

   /**
   * oss文件路径[fileDirectory+uploadFileName]
   * @return ossKey
  **/
  @ApiModelProperty(value = "oss文件路径[fileDirectory+uploadFileName]")
  public String getOssKey() {
    return ossKey;
  }

  public void setOssKey(String ossKey) {
    this.ossKey = ossKey;
  }

  @JsonIgnore
  public MsImportGoodsDataRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportGoodsDataRequest importGoodsDataRequest = (MsImportGoodsDataRequest) o;
    return Objects.equals(this.ossKey, importGoodsDataRequest.ossKey) &&
        Objects.equals(this.userInfo, importGoodsDataRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ossKey, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportGoodsDataRequest {\n");
    
    sb.append("    ossKey: ").append(toIndentedString(ossKey)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
