package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导入发票请求对象
 */
@ApiModel(description = "导入发票请求对象")

@JsonInclude(NON_NULL)
public class MsImportInvoiceRequest {
  @JsonProperty("fileUrl")
  private String fileUrl = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonIgnore
  public MsImportInvoiceRequest fileUrl(String fileUrl) {
    this.fileUrl = fileUrl;
    return this;
  }

   /**
   * 文件路径
   * @return fileUrl
  **/
  @ApiModelProperty(value = "文件路径")
  public String getFileUrl() {
    return fileUrl;
  }

  public void setFileUrl(String fileUrl) {
    this.fileUrl = fileUrl;
  }

  @JsonIgnore
  public MsImportInvoiceRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsImportInvoiceRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsImportInvoiceRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsImportInvoiceRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户姓名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户姓名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsImportInvoiceRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 组id
   * @return groupId
  **/
  @ApiModelProperty(value = "组id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportInvoiceRequest importInvoiceRequest = (MsImportInvoiceRequest) o;
    return Objects.equals(this.fileUrl, importInvoiceRequest.fileUrl) &&
        Objects.equals(this.orgIdList, importInvoiceRequest.orgIdList) &&
        Objects.equals(this.sysUserId, importInvoiceRequest.sysUserId) &&
        Objects.equals(this.sysUserName, importInvoiceRequest.sysUserName) &&
        Objects.equals(this.groupId, importInvoiceRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fileUrl, orgIdList, sysUserId, sysUserName, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportInvoiceRequest {\n");
    
    sb.append("    fileUrl: ").append(toIndentedString(fileUrl)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
