package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 新增简易征税配置
 */
@ApiModel(description = "新增简易征税配置")

@JsonInclude(NON_NULL)
public class MsInsertSimpleCollectionRequest {
  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("ratio")
  private String ratio = null;

  @JsonProperty("period")
  private String period = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsInsertSimpleCollectionRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsInsertSimpleCollectionRequest ratio(String ratio) {
    this.ratio = ratio;
    return this;
  }

   /**
   * 转出比例
   * @return ratio
  **/
  @ApiModelProperty(value = "转出比例")
  public String getRatio() {
    return ratio;
  }

  public void setRatio(String ratio) {
    this.ratio = ratio;
  }

  @JsonIgnore
  public MsInsertSimpleCollectionRequest period(String period) {
    this.period = period;
    return this;
  }

   /**
   * 生效时间
   * @return period
  **/
  @ApiModelProperty(value = "生效时间")
  public String getPeriod() {
    return period;
  }

  public void setPeriod(String period) {
    this.period = period;
  }

  @JsonIgnore
  public MsInsertSimpleCollectionRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @ApiModelProperty(value = "")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInsertSimpleCollectionRequest insertSimpleCollectionRequest = (MsInsertSimpleCollectionRequest) o;
    return Objects.equals(this.companyId, insertSimpleCollectionRequest.companyId) &&
        Objects.equals(this.ratio, insertSimpleCollectionRequest.ratio) &&
        Objects.equals(this.period, insertSimpleCollectionRequest.period) &&
        Objects.equals(this.userInfo, insertSimpleCollectionRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, ratio, period, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInsertSimpleCollectionRequest {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    ratio: ").append(toIndentedString(ratio)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
