package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 筛选器对象
 */
@ApiModel(description = "筛选器对象")

@JsonInclude(NON_NULL)
public class MsInvoiceFilter {
  @JsonProperty("controlId")
  private Long controlId = null;

  @JsonProperty("label")
  private String label = null;

  @JsonProperty("type")
  private Integer type = null;

  @JsonProperty("key")
  private String key = null;

  @JsonProperty("value")
  private Object value = null;

  @JsonProperty("condition")
  private String condition = null;

  @JsonIgnore
  public MsInvoiceFilter controlId(Long controlId) {
    this.controlId = controlId;
    return this;
  }

   /**
   * 控件id
   * @return controlId
  **/
  @ApiModelProperty(value = "控件id")
  public Long getControlId() {
    return controlId;
  }

  public void setControlId(Long controlId) {
    this.controlId = controlId;
  }

  @JsonIgnore
  public MsInvoiceFilter label(String label) {
    this.label = label;
    return this;
  }

   /**
   * 标签名称
   * @return label
  **/
  @ApiModelProperty(value = "标签名称")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  @JsonIgnore
  public MsInvoiceFilter type(Integer type) {
    this.type = type;
    return this;
  }

   /**
   * 控件类型
   * @return type
  **/
  @ApiModelProperty(value = "控件类型")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @JsonIgnore
  public MsInvoiceFilter key(String key) {
    this.key = key;
    return this;
  }

   /**
   * 标签英文名
   * @return key
  **/
  @ApiModelProperty(value = "标签英文名")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @JsonIgnore
  public MsInvoiceFilter value(Object value) {
    this.value = value;
    return this;
  }

   /**
   * 值
   * @return value
  **/
  @ApiModelProperty(value = "值")
  public Object getValue() {
    return value;
  }

  public void setValue(Object value) {
    this.value = value;
  }

  @JsonIgnore
  public MsInvoiceFilter condition(String condition) {
    this.condition = condition;
    return this;
  }

   /**
   * 条件code
   * @return condition
  **/
  @ApiModelProperty(value = "条件code")
  public String getCondition() {
    return condition;
  }

  public void setCondition(String condition) {
    this.condition = condition;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceFilter invoiceFilter = (MsInvoiceFilter) o;
    return Objects.equals(this.controlId, invoiceFilter.controlId) &&
        Objects.equals(this.label, invoiceFilter.label) &&
        Objects.equals(this.type, invoiceFilter.type) &&
        Objects.equals(this.key, invoiceFilter.key) &&
        Objects.equals(this.value, invoiceFilter.value) &&
        Objects.equals(this.condition, invoiceFilter.condition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(controlId, label, type, key, value, condition);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceFilter {\n");
    
    sb.append("    controlId: ").append(toIndentedString(controlId)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    condition: ").append(toIndentedString(condition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
