package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsInvoiceFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票筛选器对象
 */
@ApiModel(description = "发票筛选器对象")

@JsonInclude(NON_NULL)
public class MsInvoiceFilterObj {
  @JsonProperty("titleList")
  private List<MsInvoiceFilter> titleList = new ArrayList<MsInvoiceFilter>();

  @JsonProperty("dataList")
  private Object dataList = null;

  @JsonIgnore
  public MsInvoiceFilterObj titleList(List<MsInvoiceFilter> titleList) {
    this.titleList = titleList;
    return this;
  }

  public MsInvoiceFilterObj addTitleListItem(MsInvoiceFilter titleListItem) {
    this.titleList.add(titleListItem);
    return this;
  }

   /**
   * 控件集合
   * @return titleList
  **/
  @ApiModelProperty(value = "控件集合")
  public List<MsInvoiceFilter> getTitleList() {
    return titleList;
  }

  public void setTitleList(List<MsInvoiceFilter> titleList) {
    this.titleList = titleList;
  }

  @JsonIgnore
  public MsInvoiceFilterObj dataList(Object dataList) {
    this.dataList = dataList;
    return this;
  }

   /**
   * 控件数据集合
   * @return dataList
  **/
  @ApiModelProperty(value = "控件数据集合")
  public Object getDataList() {
    return dataList;
  }

  public void setDataList(Object dataList) {
    this.dataList = dataList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceFilterObj invoiceFilterObj = (MsInvoiceFilterObj) o;
    return Objects.equals(this.titleList, invoiceFilterObj.titleList) &&
        Objects.equals(this.dataList, invoiceFilterObj.dataList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(titleList, dataList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceFilterObj {\n");
    
    sb.append("    titleList: ").append(toIndentedString(titleList)).append("\n");
    sb.append("    dataList: ").append(toIndentedString(dataList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
