package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsInvoiceObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 编辑筛选组对象
 */
@ApiModel(description = "编辑筛选组对象")

@JsonInclude(NON_NULL)
public class MsInvoiceInfoObj {
  @JsonProperty("successNum")
  private Integer successNum = null;

  @JsonProperty("failNum")
  private Integer failNum = null;

  @JsonProperty("repeatNum")
  private Integer repeatNum = null;

  @JsonProperty("invoiceList")
  private List<MsInvoiceObj> invoiceList = new ArrayList<MsInvoiceObj>();

  @JsonProperty("invoiceIdList")
  private List<Long> invoiceIdList = new ArrayList<Long>();

  @JsonIgnore
  public MsInvoiceInfoObj successNum(Integer successNum) {
    this.successNum = successNum;
    return this;
  }

   /**
   * 成功条数
   * @return successNum
  **/
  @ApiModelProperty(value = "成功条数")
  public Integer getSuccessNum() {
    return successNum;
  }

  public void setSuccessNum(Integer successNum) {
    this.successNum = successNum;
  }

  @JsonIgnore
  public MsInvoiceInfoObj failNum(Integer failNum) {
    this.failNum = failNum;
    return this;
  }

   /**
   * 失败条数
   * @return failNum
  **/
  @ApiModelProperty(value = "失败条数")
  public Integer getFailNum() {
    return failNum;
  }

  public void setFailNum(Integer failNum) {
    this.failNum = failNum;
  }

  @JsonIgnore
  public MsInvoiceInfoObj repeatNum(Integer repeatNum) {
    this.repeatNum = repeatNum;
    return this;
  }

   /**
   * 重复条数
   * @return repeatNum
  **/
  @ApiModelProperty(value = "重复条数")
  public Integer getRepeatNum() {
    return repeatNum;
  }

  public void setRepeatNum(Integer repeatNum) {
    this.repeatNum = repeatNum;
  }

  @JsonIgnore
  public MsInvoiceInfoObj invoiceList(List<MsInvoiceObj> invoiceList) {
    this.invoiceList = invoiceList;
    return this;
  }

  public MsInvoiceInfoObj addInvoiceListItem(MsInvoiceObj invoiceListItem) {
    this.invoiceList.add(invoiceListItem);
    return this;
  }

   /**
   * 发票集合
   * @return invoiceList
  **/
  @ApiModelProperty(value = "发票集合")
  public List<MsInvoiceObj> getInvoiceList() {
    return invoiceList;
  }

  public void setInvoiceList(List<MsInvoiceObj> invoiceList) {
    this.invoiceList = invoiceList;
  }

  @JsonIgnore
  public MsInvoiceInfoObj invoiceIdList(List<Long> invoiceIdList) {
    this.invoiceIdList = invoiceIdList;
    return this;
  }

  public MsInvoiceInfoObj addInvoiceIdListItem(Long invoiceIdListItem) {
    this.invoiceIdList.add(invoiceIdListItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIdList
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIdList() {
    return invoiceIdList;
  }

  public void setInvoiceIdList(List<Long> invoiceIdList) {
    this.invoiceIdList = invoiceIdList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceInfoObj invoiceInfoObj = (MsInvoiceInfoObj) o;
    return Objects.equals(this.successNum, invoiceInfoObj.successNum) &&
        Objects.equals(this.failNum, invoiceInfoObj.failNum) &&
        Objects.equals(this.repeatNum, invoiceInfoObj.repeatNum) &&
        Objects.equals(this.invoiceList, invoiceInfoObj.invoiceList) &&
        Objects.equals(this.invoiceIdList, invoiceInfoObj.invoiceIdList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successNum, failNum, repeatNum, invoiceList, invoiceIdList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceInfoObj {\n");
    
    sb.append("    successNum: ").append(toIndentedString(successNum)).append("\n");
    sb.append("    failNum: ").append(toIndentedString(failNum)).append("\n");
    sb.append("    repeatNum: ").append(toIndentedString(repeatNum)).append("\n");
    sb.append("    invoiceList: ").append(toIndentedString(invoiceList)).append("\n");
    sb.append("    invoiceIdList: ").append(toIndentedString(invoiceIdList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
