package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 单一状态封锁信息
 */
@ApiModel(description = "单一状态封锁信息")

@JsonInclude(NON_NULL)
public class MsListAuthBlock {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("blockRemark")
  private String blockRemark = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("sysOrgId")
  private Long sysOrgId = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsListAuthBlock id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsListAuthBlock groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsListAuthBlock groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 集团名称
   * @return groupName
  **/
  @ApiModelProperty(value = "集团名称")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsListAuthBlock blockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
    return this;
  }

   /**
   * 封锁备注
   * @return blockRemark
  **/
  @ApiModelProperty(value = "封锁备注")
  public String getBlockRemark() {
    return blockRemark;
  }

  public void setBlockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
  }

  @JsonIgnore
  public MsListAuthBlock companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsListAuthBlock sysOrgId(Long sysOrgId) {
    this.sysOrgId = sysOrgId;
    return this;
  }

   /**
   * 组织ID
   * @return sysOrgId
  **/
  @ApiModelProperty(value = "组织ID")
  public Long getSysOrgId() {
    return sysOrgId;
  }

  public void setSysOrgId(Long sysOrgId) {
    this.sysOrgId = sysOrgId;
  }

  @JsonIgnore
  public MsListAuthBlock companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsListAuthBlock companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsListAuthBlock updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsListAuthBlock updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListAuthBlock listAuthBlock = (MsListAuthBlock) o;
    return Objects.equals(this.id, listAuthBlock.id) &&
        Objects.equals(this.groupId, listAuthBlock.groupId) &&
        Objects.equals(this.groupName, listAuthBlock.groupName) &&
        Objects.equals(this.blockRemark, listAuthBlock.blockRemark) &&
        Objects.equals(this.companyId, listAuthBlock.companyId) &&
        Objects.equals(this.sysOrgId, listAuthBlock.sysOrgId) &&
        Objects.equals(this.companyTaxNo, listAuthBlock.companyTaxNo) &&
        Objects.equals(this.companyName, listAuthBlock.companyName) &&
        Objects.equals(this.updateUserName, listAuthBlock.updateUserName) &&
        Objects.equals(this.updateTime, listAuthBlock.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupId, groupName, blockRemark, companyId, sysOrgId, companyTaxNo, companyName, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListAuthBlock {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    blockRemark: ").append(toIndentedString(blockRemark)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    sysOrgId: ").append(toIndentedString(sysOrgId)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
