package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 单一状态限额信息
 */
@ApiModel(description = "单一状态限额信息")

@JsonInclude(NON_NULL)
public class MsListAuthQuota {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("quotaMonth")
  private String quotaMonth = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("sysOrgId")
  private Long sysOrgId = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("quota")
  private String quota = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsListAuthQuota id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsListAuthQuota groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsListAuthQuota groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 集团名称
   * @return groupName
  **/
  @ApiModelProperty(value = "集团名称")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsListAuthQuota quotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
    return this;
  }

   /**
   * 限额月份
   * @return quotaMonth
  **/
  @ApiModelProperty(value = "限额月份")
  public String getQuotaMonth() {
    return quotaMonth;
  }

  public void setQuotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
  }

  @JsonIgnore
  public MsListAuthQuota companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsListAuthQuota sysOrgId(Long sysOrgId) {
    this.sysOrgId = sysOrgId;
    return this;
  }

   /**
   * 组织ID
   * @return sysOrgId
  **/
  @ApiModelProperty(value = "组织ID")
  public Long getSysOrgId() {
    return sysOrgId;
  }

  public void setSysOrgId(Long sysOrgId) {
    this.sysOrgId = sysOrgId;
  }

  @JsonIgnore
  public MsListAuthQuota companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsListAuthQuota companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsListAuthQuota quota(String quota) {
    this.quota = quota;
    return this;
  }

   /**
   * 认证限额
   * @return quota
  **/
  @ApiModelProperty(value = "认证限额")
  public String getQuota() {
    return quota;
  }

  public void setQuota(String quota) {
    this.quota = quota;
  }

  @JsonIgnore
  public MsListAuthQuota updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsListAuthQuota updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListAuthQuota listAuthQuota = (MsListAuthQuota) o;
    return Objects.equals(this.id, listAuthQuota.id) &&
        Objects.equals(this.groupId, listAuthQuota.groupId) &&
        Objects.equals(this.groupName, listAuthQuota.groupName) &&
        Objects.equals(this.quotaMonth, listAuthQuota.quotaMonth) &&
        Objects.equals(this.companyId, listAuthQuota.companyId) &&
        Objects.equals(this.sysOrgId, listAuthQuota.sysOrgId) &&
        Objects.equals(this.companyTaxNo, listAuthQuota.companyTaxNo) &&
        Objects.equals(this.companyName, listAuthQuota.companyName) &&
        Objects.equals(this.quota, listAuthQuota.quota) &&
        Objects.equals(this.updateUserName, listAuthQuota.updateUserName) &&
        Objects.equals(this.updateTime, listAuthQuota.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupId, groupName, quotaMonth, companyId, sysOrgId, companyTaxNo, companyName, quota, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListAuthQuota {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    quotaMonth: ").append(toIndentedString(quotaMonth)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    sysOrgId: ").append(toIndentedString(sysOrgId)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    quota: ").append(toIndentedString(quota)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
