package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询认证限额列表请求
 */
@ApiModel(description = "查询认证限额列表请求")

@JsonInclude(NON_NULL)
public class MsListAuthQuotaRequest {
  @JsonProperty("pageIndex")
  private Integer pageIndex = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 20;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("quotaMonths")
  private List<String> quotaMonths = new ArrayList<String>();

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("orgIds")
  private List<Long> orgIds = new ArrayList<Long>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public MsListAuthQuotaRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsListAuthQuotaRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 一页显示条数
   * @return pageSize
  **/
  @ApiModelProperty(value = "一页显示条数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsListAuthQuotaRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsListAuthQuotaRequest quotaMonths(List<String> quotaMonths) {
    this.quotaMonths = quotaMonths;
    return this;
  }

  public MsListAuthQuotaRequest addQuotaMonthsItem(String quotaMonthsItem) {
    this.quotaMonths.add(quotaMonthsItem);
    return this;
  }

   /**
   * 限额月份
   * @return quotaMonths
  **/
  @ApiModelProperty(value = "限额月份")
  public List<String> getQuotaMonths() {
    return quotaMonths;
  }

  public void setQuotaMonths(List<String> quotaMonths) {
    this.quotaMonths = quotaMonths;
  }

  @JsonIgnore
  public MsListAuthQuotaRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsListAuthQuotaRequest orgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
    return this;
  }

  public MsListAuthQuotaRequest addOrgIdsItem(Long orgIdsItem) {
    this.orgIds.add(orgIdsItem);
    return this;
  }

   /**
   * 所属组织ID数组
   * @return orgIds
  **/
  @ApiModelProperty(value = "所属组织ID数组")
  public List<Long> getOrgIds() {
    return orgIds;
  }

  public void setOrgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
  }

  @JsonIgnore
  public MsListAuthQuotaRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(value = "")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListAuthQuotaRequest listAuthQuotaRequest = (MsListAuthQuotaRequest) o;
    return Objects.equals(this.pageIndex, listAuthQuotaRequest.pageIndex) &&
        Objects.equals(this.pageSize, listAuthQuotaRequest.pageSize) &&
        Objects.equals(this.groupId, listAuthQuotaRequest.groupId) &&
        Objects.equals(this.quotaMonths, listAuthQuotaRequest.quotaMonths) &&
        Objects.equals(this.companyName, listAuthQuotaRequest.companyName) &&
        Objects.equals(this.orgIds, listAuthQuotaRequest.orgIds) &&
        Objects.equals(this.status, listAuthQuotaRequest.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageIndex, pageSize, groupId, quotaMonths, companyName, orgIds, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListAuthQuotaRequest {\n");
    
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    quotaMonths: ").append(toIndentedString(quotaMonths)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    orgIds: ").append(toIndentedString(orgIds)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
