package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsListAuthQuota;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询认证限额列表响应请求
 */
@ApiModel(description = "查询认证限额列表响应请求")

@JsonInclude(NON_NULL)
public class MsListAuthQuotaResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsListAuthQuota> result = new ArrayList<MsListAuthQuota>();

  @JsonIgnore
  public MsListAuthQuotaResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @ApiModelProperty(value = "")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsListAuthQuotaResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsListAuthQuotaResponse result(List<MsListAuthQuota> result) {
    this.result = result;
    return this;
  }

  public MsListAuthQuotaResponse addResultItem(MsListAuthQuota resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 限额信息
   * @return result
  **/
  @ApiModelProperty(value = "限额信息")
  public List<MsListAuthQuota> getResult() {
    return result;
  }

  public void setResult(List<MsListAuthQuota> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListAuthQuotaResponse listAuthQuotaResponse = (MsListAuthQuotaResponse) o;
    return Objects.equals(this.code, listAuthQuotaResponse.code) &&
        Objects.equals(this.message, listAuthQuotaResponse.message) &&
        Objects.equals(this.result, listAuthQuotaResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListAuthQuotaResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
