package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 配置组列表请求
 */
@ApiModel(description = "配置组列表请求")

@JsonInclude(NON_NULL)
public class MsListConfigGroupRequest {
  @JsonProperty("pageIndex")
  private Integer pageIndex = 1;

  @JsonProperty("pageRowCount")
  private Integer pageRowCount = 20;

  @JsonProperty("configGroupCode")
  private String configGroupCode = null;

  @JsonProperty("configGroupName")
  private String configGroupName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsListConfigGroupRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsListConfigGroupRequest pageRowCount(Integer pageRowCount) {
    this.pageRowCount = pageRowCount;
    return this;
  }

   /**
   * 每页显示条数
   * @return pageRowCount
  **/
  @ApiModelProperty(value = "每页显示条数")
  public Integer getPageRowCount() {
    return pageRowCount;
  }

  public void setPageRowCount(Integer pageRowCount) {
    this.pageRowCount = pageRowCount;
  }

  @JsonIgnore
  public MsListConfigGroupRequest configGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
    return this;
  }

   /**
   * 配置组代码-必填(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)
   * @return configGroupCode
  **/
  @ApiModelProperty(value = "配置组代码-必填(RECOG_CONFIG：识别配置组；AUTH_CONFIG：认证配置组；VERIFY_CONFIG：查验配置组；COMPLIANCE_CONFIG：合规配置组)")
  public String getConfigGroupCode() {
    return configGroupCode;
  }

  public void setConfigGroupCode(String configGroupCode) {
    this.configGroupCode = configGroupCode;
  }

  @JsonIgnore
  public MsListConfigGroupRequest configGroupName(String configGroupName) {
    this.configGroupName = configGroupName;
    return this;
  }

   /**
   * 配置组名称
   * @return configGroupName
  **/
  @ApiModelProperty(value = "配置组名称")
  public String getConfigGroupName() {
    return configGroupName;
  }

  public void setConfigGroupName(String configGroupName) {
    this.configGroupName = configGroupName;
  }

  @JsonIgnore
  public MsListConfigGroupRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsListConfigGroupRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListConfigGroupRequest listConfigGroupRequest = (MsListConfigGroupRequest) o;
    return Objects.equals(this.pageIndex, listConfigGroupRequest.pageIndex) &&
        Objects.equals(this.pageRowCount, listConfigGroupRequest.pageRowCount) &&
        Objects.equals(this.configGroupCode, listConfigGroupRequest.configGroupCode) &&
        Objects.equals(this.configGroupName, listConfigGroupRequest.configGroupName) &&
        Objects.equals(this.purchaserName, listConfigGroupRequest.purchaserName) &&
        Objects.equals(this.userInfo, listConfigGroupRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageIndex, pageRowCount, configGroupCode, configGroupName, purchaserName, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListConfigGroupRequest {\n");
    
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageRowCount: ").append(toIndentedString(pageRowCount)).append("\n");
    sb.append("    configGroupCode: ").append(toIndentedString(configGroupCode)).append("\n");
    sb.append("    configGroupName: ").append(toIndentedString(configGroupName)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
