package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 配置项信息
 */
@ApiModel(description = "配置项信息")

@JsonInclude(NON_NULL)
public class MsListConfigItem {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("configItemCode")
  private String configItemCode = null;

  @JsonProperty("configContent")
  private String configContent = null;

  @JsonProperty("configGroupId")
  private Long configGroupId = null;

  @JsonProperty("defaultConfigFlag")
  private Integer defaultConfigFlag = null;

  @JsonIgnore
  public MsListConfigItem id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 配置项ID
   * @return id
  **/
  @ApiModelProperty(value = "配置项ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsListConfigItem configItemCode(String configItemCode) {
    this.configItemCode = configItemCode;
    return this;
  }

   /**
   * 配置项代码
   * @return configItemCode
  **/
  @ApiModelProperty(value = "配置项代码")
  public String getConfigItemCode() {
    return configItemCode;
  }

  public void setConfigItemCode(String configItemCode) {
    this.configItemCode = configItemCode;
  }

  @JsonIgnore
  public MsListConfigItem configContent(String configContent) {
    this.configContent = configContent;
    return this;
  }

   /**
   * 配置内容
   * @return configContent
  **/
  @ApiModelProperty(value = "配置内容")
  public String getConfigContent() {
    return configContent;
  }

  public void setConfigContent(String configContent) {
    this.configContent = configContent;
  }

  @JsonIgnore
  public MsListConfigItem configGroupId(Long configGroupId) {
    this.configGroupId = configGroupId;
    return this;
  }

   /**
   * 配置组ID
   * @return configGroupId
  **/
  @ApiModelProperty(value = "配置组ID")
  public Long getConfigGroupId() {
    return configGroupId;
  }

  public void setConfigGroupId(Long configGroupId) {
    this.configGroupId = configGroupId;
  }

  @JsonIgnore
  public MsListConfigItem defaultConfigFlag(Integer defaultConfigFlag) {
    this.defaultConfigFlag = defaultConfigFlag;
    return this;
  }

   /**
   * 是否为默认配置(0:否,1:是)
   * @return defaultConfigFlag
  **/
  @ApiModelProperty(value = "是否为默认配置(0:否,1:是)")
  public Integer getDefaultConfigFlag() {
    return defaultConfigFlag;
  }

  public void setDefaultConfigFlag(Integer defaultConfigFlag) {
    this.defaultConfigFlag = defaultConfigFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListConfigItem listConfigItem = (MsListConfigItem) o;
    return Objects.equals(this.id, listConfigItem.id) &&
        Objects.equals(this.configItemCode, listConfigItem.configItemCode) &&
        Objects.equals(this.configContent, listConfigItem.configContent) &&
        Objects.equals(this.configGroupId, listConfigItem.configGroupId) &&
        Objects.equals(this.defaultConfigFlag, listConfigItem.defaultConfigFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, configItemCode, configContent, configGroupId, defaultConfigFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListConfigItem {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    configItemCode: ").append(toIndentedString(configItemCode)).append("\n");
    sb.append("    configContent: ").append(toIndentedString(configContent)).append("\n");
    sb.append("    configGroupId: ").append(toIndentedString(configGroupId)).append("\n");
    sb.append("    defaultConfigFlag: ").append(toIndentedString(defaultConfigFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
