package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 商品列表对象
 */
@ApiModel(description = "商品列表对象")

@JsonInclude(NON_NULL)
public class MsListGoodsInfo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsTaxShort")
  private String goodsTaxShort = null;

  @JsonProperty("taxBusinessType")
  private String taxBusinessType = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsListGoodsInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 数据主键
   * @return id
  **/
  @ApiModelProperty(value = "数据主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsListGoodsInfo goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsListGoodsInfo goodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
    return this;
  }

   /**
   * 税编简称
   * @return goodsTaxShort
  **/
  @ApiModelProperty(value = "税编简称")
  public String getGoodsTaxShort() {
    return goodsTaxShort;
  }

  public void setGoodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
  }

  @JsonIgnore
  public MsListGoodsInfo taxBusinessType(String taxBusinessType) {
    this.taxBusinessType = taxBusinessType;
    return this;
  }

   /**
   * 税编简称业务类型
   * @return taxBusinessType
  **/
  @ApiModelProperty(value = "税编简称业务类型")
  public String getTaxBusinessType() {
    return taxBusinessType;
  }

  public void setTaxBusinessType(String taxBusinessType) {
    this.taxBusinessType = taxBusinessType;
  }

  @JsonIgnore
  public MsListGoodsInfo updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsListGoodsInfo updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 操作时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "操作时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListGoodsInfo listGoodsInfo = (MsListGoodsInfo) o;
    return Objects.equals(this.id, listGoodsInfo.id) &&
        Objects.equals(this.goodsName, listGoodsInfo.goodsName) &&
        Objects.equals(this.goodsTaxShort, listGoodsInfo.goodsTaxShort) &&
        Objects.equals(this.taxBusinessType, listGoodsInfo.taxBusinessType) &&
        Objects.equals(this.updateUserName, listGoodsInfo.updateUserName) &&
        Objects.equals(this.updateTime, listGoodsInfo.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, goodsName, goodsTaxShort, taxBusinessType, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListGoodsInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsTaxShort: ").append(toIndentedString(goodsTaxShort)).append("\n");
    sb.append("    taxBusinessType: ").append(toIndentedString(taxBusinessType)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
