package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 商品列表请求
 */
@ApiModel(description = "商品列表请求")

@JsonInclude(NON_NULL)
public class MsListGoodsInfoRequest {
  @JsonProperty("pageIndex")
  private Integer pageIndex = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 20;

  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsTaxShort")
  private String goodsTaxShort = null;

  @JsonProperty("taxBusinessType")
  private String taxBusinessType = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsListGoodsInfoRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsListGoodsInfoRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页显示条数
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页显示条数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsListGoodsInfoRequest goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsListGoodsInfoRequest goodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
    return this;
  }

   /**
   * 税编简称
   * @return goodsTaxShort
  **/
  @ApiModelProperty(value = "税编简称")
  public String getGoodsTaxShort() {
    return goodsTaxShort;
  }

  public void setGoodsTaxShort(String goodsTaxShort) {
    this.goodsTaxShort = goodsTaxShort;
  }

  @JsonIgnore
  public MsListGoodsInfoRequest taxBusinessType(String taxBusinessType) {
    this.taxBusinessType = taxBusinessType;
    return this;
  }

   /**
   * 税编简称业务类型
   * @return taxBusinessType
  **/
  @ApiModelProperty(value = "税编简称业务类型")
  public String getTaxBusinessType() {
    return taxBusinessType;
  }

  public void setTaxBusinessType(String taxBusinessType) {
    this.taxBusinessType = taxBusinessType;
  }

  @JsonIgnore
  public MsListGoodsInfoRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListGoodsInfoRequest listGoodsInfoRequest = (MsListGoodsInfoRequest) o;
    return Objects.equals(this.pageIndex, listGoodsInfoRequest.pageIndex) &&
        Objects.equals(this.pageSize, listGoodsInfoRequest.pageSize) &&
        Objects.equals(this.goodsName, listGoodsInfoRequest.goodsName) &&
        Objects.equals(this.goodsTaxShort, listGoodsInfoRequest.goodsTaxShort) &&
        Objects.equals(this.taxBusinessType, listGoodsInfoRequest.taxBusinessType) &&
        Objects.equals(this.userInfo, listGoodsInfoRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageIndex, pageSize, goodsName, goodsTaxShort, taxBusinessType, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListGoodsInfoRequest {\n");
    
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsTaxShort: ").append(toIndentedString(goodsTaxShort)).append("\n");
    sb.append("    taxBusinessType: ").append(toIndentedString(taxBusinessType)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
