package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询重复响应列表
 */
@ApiModel(description = "查询重复响应列表")

@JsonInclude(NON_NULL)
public class MsListSameResponse {
  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("quotaMonth")
  private String quotaMonth = null;

  @JsonIgnore
  public MsListSameResponse companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsListSameResponse quotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
    return this;
  }

   /**
   * 限额月份
   * @return quotaMonth
  **/
  @ApiModelProperty(value = "限额月份")
  public String getQuotaMonth() {
    return quotaMonth;
  }

  public void setQuotaMonth(String quotaMonth) {
    this.quotaMonth = quotaMonth;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListSameResponse listSameResponse = (MsListSameResponse) o;
    return Objects.equals(this.companyTaxNo, listSameResponse.companyTaxNo) &&
        Objects.equals(this.quotaMonth, listSameResponse.quotaMonth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyTaxNo, quotaMonth);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListSameResponse {\n");
    
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    quotaMonth: ").append(toIndentedString(quotaMonth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
