package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 展示简易征税配置
 */
@ApiModel(description = "展示简易征税配置")

@JsonInclude(NON_NULL)
public class MsListSimpleCollectionRequest {
  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("ratio")
  private String ratio = null;

  @JsonProperty("period")
  private String period = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = null;

  @JsonProperty("pageRowCount")
  private Integer pageRowCount = null;

  @JsonProperty("userInfo")
  private MsUserInfo userInfo = null;

  @JsonIgnore
  public MsListSimpleCollectionRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsListSimpleCollectionRequest ratio(String ratio) {
    this.ratio = ratio;
    return this;
  }

   /**
   * 转出比例
   * @return ratio
  **/
  @ApiModelProperty(value = "转出比例")
  public String getRatio() {
    return ratio;
  }

  public void setRatio(String ratio) {
    this.ratio = ratio;
  }

  @JsonIgnore
  public MsListSimpleCollectionRequest period(String period) {
    this.period = period;
    return this;
  }

   /**
   * 生效时间
   * @return period
  **/
  @ApiModelProperty(value = "生效时间")
  public String getPeriod() {
    return period;
  }

  public void setPeriod(String period) {
    this.period = period;
  }

  @JsonIgnore
  public MsListSimpleCollectionRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页数
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页数")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsListSimpleCollectionRequest pageRowCount(Integer pageRowCount) {
    this.pageRowCount = pageRowCount;
    return this;
  }

   /**
   * 每页条数
   * @return pageRowCount
  **/
  @ApiModelProperty(value = "每页条数")
  public Integer getPageRowCount() {
    return pageRowCount;
  }

  public void setPageRowCount(Integer pageRowCount) {
    this.pageRowCount = pageRowCount;
  }

  @JsonIgnore
  public MsListSimpleCollectionRequest userInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @ApiModelProperty(value = "")
  public MsUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListSimpleCollectionRequest listSimpleCollectionRequest = (MsListSimpleCollectionRequest) o;
    return Objects.equals(this.companyName, listSimpleCollectionRequest.companyName) &&
        Objects.equals(this.ratio, listSimpleCollectionRequest.ratio) &&
        Objects.equals(this.period, listSimpleCollectionRequest.period) &&
        Objects.equals(this.pageIndex, listSimpleCollectionRequest.pageIndex) &&
        Objects.equals(this.pageRowCount, listSimpleCollectionRequest.pageRowCount) &&
        Objects.equals(this.userInfo, listSimpleCollectionRequest.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyName, ratio, period, pageIndex, pageRowCount, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListSimpleCollectionRequest {\n");
    
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    ratio: ").append(toIndentedString(ratio)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageRowCount: ").append(toIndentedString(pageRowCount)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
