package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsSimpleCollection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 展示简易征税配置返回值
 */
@ApiModel(description = "展示简易征税配置返回值")

@JsonInclude(NON_NULL)
public class MsListSimpleCollectionResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("result")
  private List<MsSimpleCollection> result = new ArrayList<MsSimpleCollection>();

  @JsonIgnore
  public MsListSimpleCollectionResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @ApiModelProperty(value = "")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsListSimpleCollectionResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsListSimpleCollectionResponse total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @ApiModelProperty(value = "总数")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsListSimpleCollectionResponse result(List<MsSimpleCollection> result) {
    this.result = result;
    return this;
  }

  public MsListSimpleCollectionResponse addResultItem(MsSimpleCollection resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public List<MsSimpleCollection> getResult() {
    return result;
  }

  public void setResult(List<MsSimpleCollection> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListSimpleCollectionResponse listSimpleCollectionResponse = (MsListSimpleCollectionResponse) o;
    return Objects.equals(this.code, listSimpleCollectionResponse.code) &&
        Objects.equals(this.message, listSimpleCollectionResponse.message) &&
        Objects.equals(this.total, listSimpleCollectionResponse.total) &&
        Objects.equals(this.result, listSimpleCollectionResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListSimpleCollectionResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
