package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 入参
 */
@ApiModel(description = "入参")

@JsonInclude(NON_NULL)
public class MsOptionsRequest {
  @JsonProperty("functionCode")
  private String functionCode = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsOptionsRequest functionCode(String functionCode) {
    this.functionCode = functionCode;
    return this;
  }

   /**
   * 功能code
   * @return functionCode
  **/
  @ApiModelProperty(value = "功能code")
  public String getFunctionCode() {
    return functionCode;
  }

  public void setFunctionCode(String functionCode) {
    this.functionCode = functionCode;
  }

  @JsonIgnore
  public MsOptionsRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 用户所属集团ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "用户所属集团ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOptionsRequest optionsRequest = (MsOptionsRequest) o;
    return Objects.equals(this.functionCode, optionsRequest.functionCode) &&
        Objects.equals(this.tenantId, optionsRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(functionCode, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOptionsRequest {\n");
    
    sb.append("    functionCode: ").append(toIndentedString(functionCode)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
