package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsOrgInfoTree;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 组织树
 */
@ApiModel(description = "组织树")

@JsonInclude(NON_NULL)
public class MsOrgInfoTree {
  @JsonProperty("orgStructId")
  private String orgStructId = null;

  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("companyId")
  private String companyId = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("orgCode")
  private String orgCode = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("parentId")
  private String parentId = null;

  @JsonProperty("orgLevel")
  private String orgLevel = null;

  @JsonProperty("orgType")
  private String orgType = null;

  @JsonProperty("subOrgInfoTrees")
  private List<MsOrgInfoTree> subOrgInfoTrees = new ArrayList<MsOrgInfoTree>();

  @JsonIgnore
  public MsOrgInfoTree orgStructId(String orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * 组织ID
   * @return orgStructId
  **/
  @ApiModelProperty(value = "组织ID")
  public String getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(String orgStructId) {
    this.orgStructId = orgStructId;
  }

  @JsonIgnore
  public MsOrgInfoTree groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsOrgInfoTree companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 企业ID
   * @return companyId
  **/
  @ApiModelProperty(value = "企业ID")
  public String getCompanyId() {
    return companyId;
  }

  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsOrgInfoTree taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 公司税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "公司税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsOrgInfoTree orgCode(String orgCode) {
    this.orgCode = orgCode;
    return this;
  }

   /**
   * 组织code
   * @return orgCode
  **/
  @ApiModelProperty(value = "组织code")
  public String getOrgCode() {
    return orgCode;
  }

  public void setOrgCode(String orgCode) {
    this.orgCode = orgCode;
  }

  @JsonIgnore
  public MsOrgInfoTree orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * 组织name
   * @return orgName
  **/
  @ApiModelProperty(value = "组织name")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public MsOrgInfoTree parentId(String parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父级ID(根节点=0)
   * @return parentId
  **/
  @ApiModelProperty(value = "父级ID(根节点=0)")
  public String getParentId() {
    return parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsOrgInfoTree orgLevel(String orgLevel) {
    this.orgLevel = orgLevel;
    return this;
  }

   /**
   * 节点级别(根节点=0)
   * @return orgLevel
  **/
  @ApiModelProperty(value = "节点级别(根节点=0)")
  public String getOrgLevel() {
    return orgLevel;
  }

  public void setOrgLevel(String orgLevel) {
    this.orgLevel = orgLevel;
  }

  @JsonIgnore
  public MsOrgInfoTree orgType(String orgType) {
    this.orgType = orgType;
    return this;
  }

   /**
   * 组织类型(0；集团 1：公司 2：其他组织)
   * @return orgType
  **/
  @ApiModelProperty(value = "组织类型(0；集团 1：公司 2：其他组织)")
  public String getOrgType() {
    return orgType;
  }

  public void setOrgType(String orgType) {
    this.orgType = orgType;
  }

  @JsonIgnore
  public MsOrgInfoTree subOrgInfoTrees(List<MsOrgInfoTree> subOrgInfoTrees) {
    this.subOrgInfoTrees = subOrgInfoTrees;
    return this;
  }

  public MsOrgInfoTree addSubOrgInfoTreesItem(MsOrgInfoTree subOrgInfoTreesItem) {
    this.subOrgInfoTrees.add(subOrgInfoTreesItem);
    return this;
  }

   /**
   * 子组织
   * @return subOrgInfoTrees
  **/
  @ApiModelProperty(value = "子组织")
  public List<MsOrgInfoTree> getSubOrgInfoTrees() {
    return subOrgInfoTrees;
  }

  public void setSubOrgInfoTrees(List<MsOrgInfoTree> subOrgInfoTrees) {
    this.subOrgInfoTrees = subOrgInfoTrees;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOrgInfoTree orgInfoTree = (MsOrgInfoTree) o;
    return Objects.equals(this.orgStructId, orgInfoTree.orgStructId) &&
        Objects.equals(this.groupId, orgInfoTree.groupId) &&
        Objects.equals(this.companyId, orgInfoTree.companyId) &&
        Objects.equals(this.taxNum, orgInfoTree.taxNum) &&
        Objects.equals(this.orgCode, orgInfoTree.orgCode) &&
        Objects.equals(this.orgName, orgInfoTree.orgName) &&
        Objects.equals(this.parentId, orgInfoTree.parentId) &&
        Objects.equals(this.orgLevel, orgInfoTree.orgLevel) &&
        Objects.equals(this.orgType, orgInfoTree.orgType) &&
        Objects.equals(this.subOrgInfoTrees, orgInfoTree.subOrgInfoTrees);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgStructId, groupId, companyId, taxNum, orgCode, orgName, parentId, orgLevel, orgType, subOrgInfoTrees);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOrgInfoTree {\n");
    
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    orgLevel: ").append(toIndentedString(orgLevel)).append("\n");
    sb.append("    orgType: ").append(toIndentedString(orgType)).append("\n");
    sb.append("    subOrgInfoTrees: ").append(toIndentedString(subOrgInfoTrees)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
