package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取用户组织请求
 */
@ApiModel(description = "获取用户组织请求")

@JsonInclude(NON_NULL)
public class MsOrgListRequest {
  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("orgType")
  private Integer orgType = null;

  @JsonIgnore
  public MsOrgListRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 1有效0无效
   * @return status
  **/
  @ApiModelProperty(value = "状态 1有效0无效")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsOrgListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsOrgListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsOrgListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 分页行数
   * @return row
  **/
  @ApiModelProperty(value = "分页行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsOrgListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 分页数
   * @return page
  **/
  @ApiModelProperty(value = "分页数")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsOrgListRequest orgType(Integer orgType) {
    this.orgType = orgType;
    return this;
  }

   /**
   * 组织类型
   * @return orgType
  **/
  @ApiModelProperty(value = "组织类型")
  public Integer getOrgType() {
    return orgType;
  }

  public void setOrgType(Integer orgType) {
    this.orgType = orgType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOrgListRequest orgListRequest = (MsOrgListRequest) o;
    return Objects.equals(this.status, orgListRequest.status) &&
        Objects.equals(this.tenantId, orgListRequest.tenantId) &&
        Objects.equals(this.userId, orgListRequest.userId) &&
        Objects.equals(this.row, orgListRequest.row) &&
        Objects.equals(this.page, orgListRequest.page) &&
        Objects.equals(this.orgType, orgListRequest.orgType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, tenantId, userId, row, page, orgType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOrgListRequest {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    orgType: ").append(toIndentedString(orgType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
