package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 组织结果集
 */
@ApiModel(description = "组织结果集")

@JsonInclude(NON_NULL)
public class MsOrgModel {
  @JsonProperty("orgId")
  private Long orgId = null;

  @JsonProperty("orgCode")
  private String orgCode = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("parentId")
  private String parentId = null;

  @JsonProperty("orgType")
  private Integer orgType = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("companyCode")
  private String companyCode = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("orgDesc")
  private String orgDesc = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonIgnore
  public MsOrgModel orgId(Long orgId) {
    this.orgId = orgId;
    return this;
  }

   /**
   * orgId
   * @return orgId
  **/
  @ApiModelProperty(value = "orgId")
  public Long getOrgId() {
    return orgId;
  }

  public void setOrgId(Long orgId) {
    this.orgId = orgId;
  }

  @JsonIgnore
  public MsOrgModel orgCode(String orgCode) {
    this.orgCode = orgCode;
    return this;
  }

   /**
   * orgCode
   * @return orgCode
  **/
  @ApiModelProperty(value = "orgCode")
  public String getOrgCode() {
    return orgCode;
  }

  public void setOrgCode(String orgCode) {
    this.orgCode = orgCode;
  }

  @JsonIgnore
  public MsOrgModel orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * orgName
   * @return orgName
  **/
  @ApiModelProperty(value = "orgName")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public MsOrgModel tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * tenantId
   * @return tenantId
  **/
  @ApiModelProperty(value = "tenantId")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsOrgModel companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * companyId
   * @return companyId
  **/
  @ApiModelProperty(value = "companyId")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsOrgModel parentId(String parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * parentId
   * @return parentId
  **/
  @ApiModelProperty(value = "parentId")
  public String getParentId() {
    return parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsOrgModel orgType(Integer orgType) {
    this.orgType = orgType;
    return this;
  }

   /**
   * orgType
   * @return orgType
  **/
  @ApiModelProperty(value = "orgType")
  public Integer getOrgType() {
    return orgType;
  }

  public void setOrgType(Integer orgType) {
    this.orgType = orgType;
  }

  @JsonIgnore
  public MsOrgModel taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * taxNum
   * @return taxNum
  **/
  @ApiModelProperty(value = "taxNum")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsOrgModel companyCode(String companyCode) {
    this.companyCode = companyCode;
    return this;
  }

   /**
   * companyCode
   * @return companyCode
  **/
  @ApiModelProperty(value = "companyCode")
  public String getCompanyCode() {
    return companyCode;
  }

  public void setCompanyCode(String companyCode) {
    this.companyCode = companyCode;
  }

  @JsonIgnore
  public MsOrgModel companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * companyName
   * @return companyName
  **/
  @ApiModelProperty(value = "companyName")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsOrgModel orgDesc(String orgDesc) {
    this.orgDesc = orgDesc;
    return this;
  }

   /**
   * orgDesc
   * @return orgDesc
  **/
  @ApiModelProperty(value = "orgDesc")
  public String getOrgDesc() {
    return orgDesc;
  }

  public void setOrgDesc(String orgDesc) {
    this.orgDesc = orgDesc;
  }

  @JsonIgnore
  public MsOrgModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * status
   * @return status
  **/
  @ApiModelProperty(value = "status")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsOrgModel tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * tenantCode
   * @return tenantCode
  **/
  @ApiModelProperty(value = "tenantCode")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsOrgModel tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * tenantName
   * @return tenantName
  **/
  @ApiModelProperty(value = "tenantName")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOrgModel orgModel = (MsOrgModel) o;
    return Objects.equals(this.orgId, orgModel.orgId) &&
        Objects.equals(this.orgCode, orgModel.orgCode) &&
        Objects.equals(this.orgName, orgModel.orgName) &&
        Objects.equals(this.tenantId, orgModel.tenantId) &&
        Objects.equals(this.companyId, orgModel.companyId) &&
        Objects.equals(this.parentId, orgModel.parentId) &&
        Objects.equals(this.orgType, orgModel.orgType) &&
        Objects.equals(this.taxNum, orgModel.taxNum) &&
        Objects.equals(this.companyCode, orgModel.companyCode) &&
        Objects.equals(this.companyName, orgModel.companyName) &&
        Objects.equals(this.orgDesc, orgModel.orgDesc) &&
        Objects.equals(this.status, orgModel.status) &&
        Objects.equals(this.tenantCode, orgModel.tenantCode) &&
        Objects.equals(this.tenantName, orgModel.tenantName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgId, orgCode, orgName, tenantId, companyId, parentId, orgType, taxNum, companyCode, companyName, orgDesc, status, tenantCode, tenantName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOrgModel {\n");
    
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    orgType: ").append(toIndentedString(orgType)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    companyCode: ").append(toIndentedString(companyCode)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    orgDesc: ").append(toIndentedString(orgDesc)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
