package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 影像采集的扩展字段
 */
@ApiModel(description = "影像采集的扩展字段")

@JsonInclude(NON_NULL)
public class MsPcfRecogExtFieldModel {
  @JsonProperty("fieldSeq")
  private String fieldSeq = null;

  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonProperty("fieldType")
  private String fieldType = null;

  @JsonProperty("fieldValue")
  private String fieldValue = null;

  @JsonProperty("fieldRequire")
  private String fieldRequire = null;

  @JsonIgnore
  public MsPcfRecogExtFieldModel fieldSeq(String fieldSeq) {
    this.fieldSeq = fieldSeq;
    return this;
  }

   /**
   * 扩展字段序号
   * @return fieldSeq
  **/
  @ApiModelProperty(value = "扩展字段序号")
  public String getFieldSeq() {
    return fieldSeq;
  }

  public void setFieldSeq(String fieldSeq) {
    this.fieldSeq = fieldSeq;
  }

  @JsonIgnore
  public MsPcfRecogExtFieldModel fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * 扩展字段名称
   * @return fieldName
  **/
  @ApiModelProperty(value = "扩展字段名称")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @JsonIgnore
  public MsPcfRecogExtFieldModel fieldType(String fieldType) {
    this.fieldType = fieldType;
    return this;
  }

   /**
   * 扩展字段类型
   * @return fieldType
  **/
  @ApiModelProperty(value = "扩展字段类型")
  public String getFieldType() {
    return fieldType;
  }

  public void setFieldType(String fieldType) {
    this.fieldType = fieldType;
  }

  @JsonIgnore
  public MsPcfRecogExtFieldModel fieldValue(String fieldValue) {
    this.fieldValue = fieldValue;
    return this;
  }

   /**
   * 扩展字段值
   * @return fieldValue
  **/
  @ApiModelProperty(value = "扩展字段值")
  public String getFieldValue() {
    return fieldValue;
  }

  public void setFieldValue(String fieldValue) {
    this.fieldValue = fieldValue;
  }

  @JsonIgnore
  public MsPcfRecogExtFieldModel fieldRequire(String fieldRequire) {
    this.fieldRequire = fieldRequire;
    return this;
  }

   /**
   * 扩展字段是否必须 0 - 非必须 1 - 必须
   * @return fieldRequire
  **/
  @ApiModelProperty(value = "扩展字段是否必须 0 - 非必须 1 - 必须")
  public String getFieldRequire() {
    return fieldRequire;
  }

  public void setFieldRequire(String fieldRequire) {
    this.fieldRequire = fieldRequire;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsPcfRecogExtFieldModel pcfRecogExtFieldModel = (MsPcfRecogExtFieldModel) o;
    return Objects.equals(this.fieldSeq, pcfRecogExtFieldModel.fieldSeq) &&
        Objects.equals(this.fieldName, pcfRecogExtFieldModel.fieldName) &&
        Objects.equals(this.fieldType, pcfRecogExtFieldModel.fieldType) &&
        Objects.equals(this.fieldValue, pcfRecogExtFieldModel.fieldValue) &&
        Objects.equals(this.fieldRequire, pcfRecogExtFieldModel.fieldRequire);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldSeq, fieldName, fieldType, fieldValue, fieldRequire);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsPcfRecogExtFieldModel {\n");
    
    sb.append("    fieldSeq: ").append(toIndentedString(fieldSeq)).append("\n");
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    fieldType: ").append(toIndentedString(fieldType)).append("\n");
    sb.append("    fieldValue: ").append(toIndentedString(fieldValue)).append("\n");
    sb.append("    fieldRequire: ").append(toIndentedString(fieldRequire)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
