package com.xforceplus.purconfig.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")
@JsonInclude(NON_NULL)
@Data
public class MsPcfRuleGroupDetailModel {
    @JsonProperty("id")
    @ApiModelProperty(value = "id")
    private String id = null;

    @JsonProperty("groupId")
    @ApiModelProperty(value = "集团Id")
    private String groupId = null;

    @JsonProperty("ruleGroupCode")
    @ApiModelProperty(value = "规则组代码，唯一标示配置的作用范围")
    private String ruleGroupCode = null;

    @JsonProperty("ruleGroupName")
    @ApiModelProperty(value = "规则组名称")
    private String ruleGroupName = null;

    @JsonProperty("ruleGroupComment")
    @ApiModelProperty(value = "规则组备注")
    private String ruleGroupComment = null;

    @JsonProperty("ruleGroupStatus")
    @ApiModelProperty(value = "状态")
    private Integer ruleGroupStatus = null;

    @JsonProperty("ruleGroupType")
    @ApiModelProperty(value = "规则组类型. 1 - 业务配置 2 - 合规项")
    private String ruleGroupType = null;

    @JsonProperty("ruleGroupPriority")
    @ApiModelProperty(value = "规则组优先级，0 - 低， 1 - 中，2 - 高")
    private String ruleGroupPriority = null;

//    @JsonProperty("triggerPoint")
//    @ApiModelProperty(value = "规则组的触发点")
//    private String triggerPoint = null;

    @JsonProperty("defaultConfig")
    @ApiModelProperty(value = "是否默认配置 0 - 否，1 - 是")
    private String defaultConfig = null;

//    @JsonProperty("ruleContent")
//    @ApiModelProperty(value = "规则内容")
//    private Object ruleContent = null;

    @JsonProperty("createTime")
    @ApiModelProperty(value = "创建时间")
    private String createTime = null;

    @JsonProperty("createUserName")
    @ApiModelProperty(value = "添加人姓名")
    private String createUserName = null;

    @JsonProperty("createUserId")
    @ApiModelProperty(value = "添加人ID")
    private String createUserId = null;

    @ApiModelProperty(value = "更新用户Id")
    private String updateUserId;

    @ApiModelProperty(value = "更新用户名称")
    private String updateUserName;

    @ApiModelProperty(value = "更新时间")
    private String updateTime;

    private List<MsPcfRuleSimpleModel> rules;

}
