package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsPcfRuleModel {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("ruleGroupId")
  private String ruleGroupId = null;

  @JsonProperty("triggerPoint")
  private String triggerPoint = null;

  @JsonProperty("defaultConfig")
  private String defaultConfig = null;

  @JsonProperty("ruleContent")
  private Object ruleContent = null;

  @JsonIgnore
  public MsPcfRuleModel id(String id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @JsonIgnore
  public MsPcfRuleModel groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团Id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团Id")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsPcfRuleModel ruleGroupId(String ruleGroupId) {
    this.ruleGroupId = ruleGroupId;
    return this;
  }

   /**
   * 规则组Id
   * @return ruleGroupId
  **/
  @ApiModelProperty(value = "规则组Id")
  public String getRuleGroupId() {
    return ruleGroupId;
  }

  public void setRuleGroupId(String ruleGroupId) {
    this.ruleGroupId = ruleGroupId;
  }

  @JsonIgnore
  public MsPcfRuleModel triggerPoint(String triggerPoint) {
    this.triggerPoint = triggerPoint;
    return this;
  }

   /**
   * 规则组的触发点
   * @return triggerPoint
  **/
  @ApiModelProperty(value = "规则组的触发点")
  public String getTriggerPoint() {
    return triggerPoint;
  }

  public void setTriggerPoint(String triggerPoint) {
    this.triggerPoint = triggerPoint;
  }

  @JsonIgnore
  public MsPcfRuleModel defaultConfig(String defaultConfig) {
    this.defaultConfig = defaultConfig;
    return this;
  }

   /**
   * 是否默认配置 0 - 否，1 - 是
   * @return defaultConfig
  **/
  @ApiModelProperty(value = "是否默认配置 0 - 否，1 - 是")
  public String getDefaultConfig() {
    return defaultConfig;
  }

  public void setDefaultConfig(String defaultConfig) {
    this.defaultConfig = defaultConfig;
  }

  @JsonIgnore
  public MsPcfRuleModel ruleContent(Object ruleContent) {
    this.ruleContent = ruleContent;
    return this;
  }

   /**
   * 规则内容
   * @return ruleContent
  **/
  @ApiModelProperty(value = "规则内容")
  public Object getRuleContent() {
    return ruleContent;
  }

  public void setRuleContent(Object ruleContent) {
    this.ruleContent = ruleContent;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsPcfRuleModel pcfRuleModel = (MsPcfRuleModel) o;
    return Objects.equals(this.id, pcfRuleModel.id) &&
        Objects.equals(this.groupId, pcfRuleModel.groupId) &&
        Objects.equals(this.ruleGroupId, pcfRuleModel.ruleGroupId) &&
        Objects.equals(this.triggerPoint, pcfRuleModel.triggerPoint) &&
        Objects.equals(this.defaultConfig, pcfRuleModel.defaultConfig) &&
        Objects.equals(this.ruleContent, pcfRuleModel.ruleContent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupId, ruleGroupId, triggerPoint, defaultConfig, ruleContent);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsPcfRuleModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    ruleGroupId: ").append(toIndentedString(ruleGroupId)).append("\n");
    sb.append("    triggerPoint: ").append(toIndentedString(triggerPoint)).append("\n");
    sb.append("    defaultConfig: ").append(toIndentedString(defaultConfig)).append("\n");
    sb.append("    ruleContent: ").append(toIndentedString(ruleContent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
