package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsQuotaTotalDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * tab页数据
 */
@ApiModel(description = "tab页数据")

@JsonInclude(NON_NULL)
public class MsQuotaTabResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsQuotaTotalDetail> result = new ArrayList<MsQuotaTotalDetail>();

  @JsonIgnore
  public MsQuotaTabResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 1-成功
   * @return code
  **/
  @ApiModelProperty(value = "1-成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsQuotaTabResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsQuotaTabResponse result(List<MsQuotaTotalDetail> result) {
    this.result = result;
    return this;
  }

  public MsQuotaTabResponse addResultItem(MsQuotaTotalDetail resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 结果
   * @return result
  **/
  @ApiModelProperty(value = "结果")
  public List<MsQuotaTotalDetail> getResult() {
    return result;
  }

  public void setResult(List<MsQuotaTotalDetail> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQuotaTabResponse quotaTabResponse = (MsQuotaTabResponse) o;
    return Objects.equals(this.code, quotaTabResponse.code) &&
        Objects.equals(this.message, quotaTabResponse.message) &&
        Objects.equals(this.result, quotaTabResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQuotaTabResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
