package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.purconfig.client.model.MsOrgModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 组织结果集
 */
@ApiModel(description = "组织结果集")

@JsonInclude(NON_NULL)
public class MsResultBean {
  @JsonProperty("size")
  private Integer size = null;

  @JsonProperty("number")
  private Long number = null;

  @JsonProperty("totalElements")
  private Integer totalElements = null;

  @JsonProperty("last")
  private Integer last = null;

  @JsonProperty("totalPages")
  private Integer totalPages = null;

  @JsonProperty("first")
  private Integer first = null;

  @JsonProperty("numberOfElements")
  private Integer numberOfElements = null;

  @JsonProperty("content")
  private List<MsOrgModel> content = new ArrayList<MsOrgModel>();

  @JsonIgnore
  public MsResultBean size(Integer size) {
    this.size = size;
    return this;
  }

   /**
   * size
   * @return size
  **/
  @ApiModelProperty(value = "size")
  public Integer getSize() {
    return size;
  }

  public void setSize(Integer size) {
    this.size = size;
  }

  @JsonIgnore
  public MsResultBean number(Long number) {
    this.number = number;
    return this;
  }

   /**
   * number
   * @return number
  **/
  @ApiModelProperty(value = "number")
  public Long getNumber() {
    return number;
  }

  public void setNumber(Long number) {
    this.number = number;
  }

  @JsonIgnore
  public MsResultBean totalElements(Integer totalElements) {
    this.totalElements = totalElements;
    return this;
  }

   /**
   * totalElements
   * @return totalElements
  **/
  @ApiModelProperty(value = "totalElements")
  public Integer getTotalElements() {
    return totalElements;
  }

  public void setTotalElements(Integer totalElements) {
    this.totalElements = totalElements;
  }

  @JsonIgnore
  public MsResultBean last(Integer last) {
    this.last = last;
    return this;
  }

   /**
   * last
   * @return last
  **/
  @ApiModelProperty(value = "last")
  public Integer getLast() {
    return last;
  }

  public void setLast(Integer last) {
    this.last = last;
  }

  @JsonIgnore
  public MsResultBean totalPages(Integer totalPages) {
    this.totalPages = totalPages;
    return this;
  }

   /**
   * totalPages
   * @return totalPages
  **/
  @ApiModelProperty(value = "totalPages")
  public Integer getTotalPages() {
    return totalPages;
  }

  public void setTotalPages(Integer totalPages) {
    this.totalPages = totalPages;
  }

  @JsonIgnore
  public MsResultBean first(Integer first) {
    this.first = first;
    return this;
  }

   /**
   * first
   * @return first
  **/
  @ApiModelProperty(value = "first")
  public Integer getFirst() {
    return first;
  }

  public void setFirst(Integer first) {
    this.first = first;
  }

  @JsonIgnore
  public MsResultBean numberOfElements(Integer numberOfElements) {
    this.numberOfElements = numberOfElements;
    return this;
  }

   /**
   * numberOfElements
   * @return numberOfElements
  **/
  @ApiModelProperty(value = "numberOfElements")
  public Integer getNumberOfElements() {
    return numberOfElements;
  }

  public void setNumberOfElements(Integer numberOfElements) {
    this.numberOfElements = numberOfElements;
  }

  @JsonIgnore
  public MsResultBean content(List<MsOrgModel> content) {
    this.content = content;
    return this;
  }

  public MsResultBean addContentItem(MsOrgModel contentItem) {
    this.content.add(contentItem);
    return this;
  }

   /**
   * Get content
   * @return content
  **/
  @ApiModelProperty(value = "")
  public List<MsOrgModel> getContent() {
    return content;
  }

  public void setContent(List<MsOrgModel> content) {
    this.content = content;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsResultBean resultBean = (MsResultBean) o;
    return Objects.equals(this.size, resultBean.size) &&
        Objects.equals(this.number, resultBean.number) &&
        Objects.equals(this.totalElements, resultBean.totalElements) &&
        Objects.equals(this.last, resultBean.last) &&
        Objects.equals(this.totalPages, resultBean.totalPages) &&
        Objects.equals(this.first, resultBean.first) &&
        Objects.equals(this.numberOfElements, resultBean.numberOfElements) &&
        Objects.equals(this.content, resultBean.content);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, number, totalElements, last, totalPages, first, numberOfElements, content);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsResultBean {\n");
    
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    totalElements: ").append(toIndentedString(totalElements)).append("\n");
    sb.append("    last: ").append(toIndentedString(last)).append("\n");
    sb.append("    totalPages: ").append(toIndentedString(totalPages)).append("\n");
    sb.append("    first: ").append(toIndentedString(first)).append("\n");
    sb.append("    numberOfElements: ").append(toIndentedString(numberOfElements)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
