package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 搜索规则组的名称
 */
@ApiModel(description = "搜索规则组的名称")

@JsonInclude(NON_NULL)
public class MsSearchRuleGroupRequest {
  @JsonProperty("ruleGroupName")
  private String ruleGroupName = null;

  @JsonProperty("groupId")
  private String groupId = null;

  @JsonIgnore
  public MsSearchRuleGroupRequest ruleGroupName(String ruleGroupName) {
    this.ruleGroupName = ruleGroupName;
    return this;
  }

   /**
   * 关键词
   * @return ruleGroupName
  **/
  @ApiModelProperty(value = "关键词")
  public String getRuleGroupName() {
    return ruleGroupName;
  }

  public void setRuleGroupName(String ruleGroupName) {
    this.ruleGroupName = ruleGroupName;
  }

  @JsonIgnore
  public MsSearchRuleGroupRequest groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团Id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团Id")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSearchRuleGroupRequest searchRuleGroupRequest = (MsSearchRuleGroupRequest) o;
    return Objects.equals(this.ruleGroupName, searchRuleGroupRequest.ruleGroupName) &&
        Objects.equals(this.groupId, searchRuleGroupRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ruleGroupName, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSearchRuleGroupRequest {\n");
    
    sb.append("    ruleGroupName: ").append(toIndentedString(ruleGroupName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
