package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 单条简易征税配置
 */
@ApiModel(description = "单条简易征税配置")

@JsonInclude(NON_NULL)
public class MsSimpleCollection {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("period")
  private String period = null;

  @JsonProperty("ratio")
  private String ratio = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSimpleCollection id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 规则id
   * @return id
  **/
  @ApiModelProperty(value = "规则id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSimpleCollection companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsSimpleCollection companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsSimpleCollection period(String period) {
    this.period = period;
    return this;
  }

   /**
   * 生效时间
   * @return period
  **/
  @ApiModelProperty(value = "生效时间")
  public String getPeriod() {
    return period;
  }

  public void setPeriod(String period) {
    this.period = period;
  }

  @JsonIgnore
  public MsSimpleCollection ratio(String ratio) {
    this.ratio = ratio;
    return this;
  }

   /**
   * 转出比例
   * @return ratio
  **/
  @ApiModelProperty(value = "转出比例")
  public String getRatio() {
    return ratio;
  }

  public void setRatio(String ratio) {
    this.ratio = ratio;
  }

  @JsonIgnore
  public MsSimpleCollection updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新用户名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新用户名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSimpleCollection updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSimpleCollection simpleCollection = (MsSimpleCollection) o;
    return Objects.equals(this.id, simpleCollection.id) &&
        Objects.equals(this.companyId, simpleCollection.companyId) &&
        Objects.equals(this.companyName, simpleCollection.companyName) &&
        Objects.equals(this.period, simpleCollection.period) &&
        Objects.equals(this.ratio, simpleCollection.ratio) &&
        Objects.equals(this.updateUserName, simpleCollection.updateUserName) &&
        Objects.equals(this.updateTime, simpleCollection.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, companyId, companyName, period, ratio, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSimpleCollection {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    ratio: ").append(toIndentedString(ratio)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
