package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 转出配置项
 */
@ApiModel(description = "转出配置项")

@JsonInclude(NON_NULL)
public class MsTurnOutItem {
  @JsonProperty("id")
  private Integer id = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("checkedFlag")
  private String checkedFlag = null;

  @JsonProperty("value")
  private String value = null;

  @JsonIgnore
  public MsTurnOutItem id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 序号
   * @return id
  **/
  @ApiModelProperty(value = "序号")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  @JsonIgnore
  public MsTurnOutItem name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 名称
   * @return name
  **/
  @ApiModelProperty(value = "名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public MsTurnOutItem checkedFlag(String checkedFlag) {
    this.checkedFlag = checkedFlag;
    return this;
  }

   /**
   * 是否启用
   * @return checkedFlag
  **/
  @ApiModelProperty(value = "是否启用")
  public String getCheckedFlag() {
    return checkedFlag;
  }

  public void setCheckedFlag(String checkedFlag) {
    this.checkedFlag = checkedFlag;
  }

  @JsonIgnore
  public MsTurnOutItem value(String value) {
    this.value = value;
    return this;
  }

   /**
   * 值
   * @return value
  **/
  @ApiModelProperty(value = "值")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTurnOutItem turnOutItem = (MsTurnOutItem) o;
    return Objects.equals(this.id, turnOutItem.id) &&
        Objects.equals(this.name, turnOutItem.name) &&
        Objects.equals(this.checkedFlag, turnOutItem.checkedFlag) &&
        Objects.equals(this.value, turnOutItem.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, checkedFlag, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTurnOutItem {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    checkedFlag: ").append(toIndentedString(checkedFlag)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
