package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 公司结果集
 */
@ApiModel(description = "公司结果集")

@JsonInclude(NON_NULL)
public class MsUcenterCompanyModel {
  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyCode")
  private String companyCode = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("traditionAuthenFlag")
  private Integer traditionAuthenFlag = null;

  @JsonProperty("inspectionServiceFlag")
  private Integer inspectionServiceFlag = null;

  @JsonProperty("speedInspectionChannelFlag")
  private Integer speedInspectionChannelFlag = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("cquota")
  private String cquota = null;

  @JsonIgnore
  public MsUcenterCompanyModel companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * companyId
   * @return companyId
  **/
  @ApiModelProperty(value = "companyId")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsUcenterCompanyModel companyCode(String companyCode) {
    this.companyCode = companyCode;
    return this;
  }

   /**
   * companyCode
   * @return companyCode
  **/
  @ApiModelProperty(value = "companyCode")
  public String getCompanyCode() {
    return companyCode;
  }

  public void setCompanyCode(String companyCode) {
    this.companyCode = companyCode;
  }

  @JsonIgnore
  public MsUcenterCompanyModel companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * companyName
   * @return companyName
  **/
  @ApiModelProperty(value = "companyName")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsUcenterCompanyModel taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * taxNum
   * @return taxNum
  **/
  @ApiModelProperty(value = "taxNum")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsUcenterCompanyModel traditionAuthenFlag(Integer traditionAuthenFlag) {
    this.traditionAuthenFlag = traditionAuthenFlag;
    return this;
  }

   /**
   * traditionAuthenFlag
   * @return traditionAuthenFlag
  **/
  @ApiModelProperty(value = "traditionAuthenFlag")
  public Integer getTraditionAuthenFlag() {
    return traditionAuthenFlag;
  }

  public void setTraditionAuthenFlag(Integer traditionAuthenFlag) {
    this.traditionAuthenFlag = traditionAuthenFlag;
  }

  @JsonIgnore
  public MsUcenterCompanyModel inspectionServiceFlag(Integer inspectionServiceFlag) {
    this.inspectionServiceFlag = inspectionServiceFlag;
    return this;
  }

   /**
   * inspectionServiceFlag
   * @return inspectionServiceFlag
  **/
  @ApiModelProperty(value = "inspectionServiceFlag")
  public Integer getInspectionServiceFlag() {
    return inspectionServiceFlag;
  }

  public void setInspectionServiceFlag(Integer inspectionServiceFlag) {
    this.inspectionServiceFlag = inspectionServiceFlag;
  }

  @JsonIgnore
  public MsUcenterCompanyModel speedInspectionChannelFlag(Integer speedInspectionChannelFlag) {
    this.speedInspectionChannelFlag = speedInspectionChannelFlag;
    return this;
  }

   /**
   * speedInspectionChannelFlag
   * @return speedInspectionChannelFlag
  **/
  @ApiModelProperty(value = "speedInspectionChannelFlag")
  public Integer getSpeedInspectionChannelFlag() {
    return speedInspectionChannelFlag;
  }

  public void setSpeedInspectionChannelFlag(Integer speedInspectionChannelFlag) {
    this.speedInspectionChannelFlag = speedInspectionChannelFlag;
  }

  @JsonIgnore
  public MsUcenterCompanyModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * status
   * @return status
  **/
  @ApiModelProperty(value = "status")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsUcenterCompanyModel cquota(String cquota) {
    this.cquota = cquota;
    return this;
  }

   /**
   * cquota
   * @return cquota
  **/
  @ApiModelProperty(value = "cquota")
  public String getCquota() {
    return cquota;
  }

  public void setCquota(String cquota) {
    this.cquota = cquota;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUcenterCompanyModel ucenterCompanyModel = (MsUcenterCompanyModel) o;
    return Objects.equals(this.companyId, ucenterCompanyModel.companyId) &&
        Objects.equals(this.companyCode, ucenterCompanyModel.companyCode) &&
        Objects.equals(this.companyName, ucenterCompanyModel.companyName) &&
        Objects.equals(this.taxNum, ucenterCompanyModel.taxNum) &&
        Objects.equals(this.traditionAuthenFlag, ucenterCompanyModel.traditionAuthenFlag) &&
        Objects.equals(this.inspectionServiceFlag, ucenterCompanyModel.inspectionServiceFlag) &&
        Objects.equals(this.speedInspectionChannelFlag, ucenterCompanyModel.speedInspectionChannelFlag) &&
        Objects.equals(this.status, ucenterCompanyModel.status) &&
        Objects.equals(this.cquota, ucenterCompanyModel.cquota);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, companyCode, companyName, taxNum, traditionAuthenFlag, inspectionServiceFlag, speedInspectionChannelFlag, status, cquota);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUcenterCompanyModel {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyCode: ").append(toIndentedString(companyCode)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    traditionAuthenFlag: ").append(toIndentedString(traditionAuthenFlag)).append("\n");
    sb.append("    inspectionServiceFlag: ").append(toIndentedString(inspectionServiceFlag)).append("\n");
    sb.append("    speedInspectionChannelFlag: ").append(toIndentedString(speedInspectionChannelFlag)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    cquota: ").append(toIndentedString(cquota)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
