package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取用户公司请求信息
 */
@ApiModel(description = "获取用户公司请求信息")

@JsonInclude(NON_NULL)
public class MsUcenterCompanyRequest {
  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("companyCode")
  private String companyCode = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonIgnore
  public MsUcenterCompanyRequest taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsUcenterCompanyRequest companyCode(String companyCode) {
    this.companyCode = companyCode;
    return this;
  }

   /**
   * 公司代码
   * @return companyCode
  **/
  @ApiModelProperty(value = "公司代码")
  public String getCompanyCode() {
    return companyCode;
  }

  public void setCompanyCode(String companyCode) {
    this.companyCode = companyCode;
  }

  @JsonIgnore
  public MsUcenterCompanyRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsUcenterCompanyRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsUcenterCompanyRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsUcenterCompanyRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 分页行数
   * @return row
  **/
  @ApiModelProperty(value = "分页行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsUcenterCompanyRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 分页数
   * @return page
  **/
  @ApiModelProperty(value = "分页数")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUcenterCompanyRequest ucenterCompanyRequest = (MsUcenterCompanyRequest) o;
    return Objects.equals(this.taxNum, ucenterCompanyRequest.taxNum) &&
        Objects.equals(this.companyCode, ucenterCompanyRequest.companyCode) &&
        Objects.equals(this.companyId, ucenterCompanyRequest.companyId) &&
        Objects.equals(this.companyName, ucenterCompanyRequest.companyName) &&
        Objects.equals(this.tenantId, ucenterCompanyRequest.tenantId) &&
        Objects.equals(this.row, ucenterCompanyRequest.row) &&
        Objects.equals(this.page, ucenterCompanyRequest.page);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNum, companyCode, companyId, companyName, tenantId, row, page);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUcenterCompanyRequest {\n");
    
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    companyCode: ").append(toIndentedString(companyCode)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
