package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 更新认证封锁
 */
@ApiModel(description = "更新认证封锁")

@JsonInclude(NON_NULL)
public class MsUpdateAuthBlockRequest {
  @JsonProperty("ids")
  private List<Long> ids = new ArrayList<Long>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("blockRemark")
  private String blockRemark = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonIgnore
  public MsUpdateAuthBlockRequest ids(List<Long> ids) {
    this.ids = ids;
    return this;
  }

  public MsUpdateAuthBlockRequest addIdsItem(Long idsItem) {
    this.ids.add(idsItem);
    return this;
  }

   /**
   * 更新id集合
   * @return ids
  **/
  @ApiModelProperty(value = "更新id集合")
  public List<Long> getIds() {
    return ids;
  }

  public void setIds(List<Long> ids) {
    this.ids = ids;
  }

  @JsonIgnore
  public MsUpdateAuthBlockRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 当前状态，1-未封锁，2-已封锁
   * @return status
  **/
  @ApiModelProperty(value = "当前状态，1-未封锁，2-已封锁")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsUpdateAuthBlockRequest blockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
    return this;
  }

   /**
   * 封锁备注
   * @return blockRemark
  **/
  @ApiModelProperty(value = "封锁备注")
  public String getBlockRemark() {
    return blockRemark;
  }

  public void setBlockRemark(String blockRemark) {
    this.blockRemark = blockRemark;
  }

  @JsonIgnore
  public MsUpdateAuthBlockRequest updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 操作人id
   * @return updateUserId
  **/
  @ApiModelProperty(value = "操作人id")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsUpdateAuthBlockRequest updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 操作人名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "操作人名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateAuthBlockRequest updateAuthBlockRequest = (MsUpdateAuthBlockRequest) o;
    return Objects.equals(this.ids, updateAuthBlockRequest.ids) &&
        Objects.equals(this.status, updateAuthBlockRequest.status) &&
        Objects.equals(this.blockRemark, updateAuthBlockRequest.blockRemark) &&
        Objects.equals(this.updateUserId, updateAuthBlockRequest.updateUserId) &&
        Objects.equals(this.updateUserName, updateAuthBlockRequest.updateUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ids, status, blockRemark, updateUserId, updateUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateAuthBlockRequest {\n");
    
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    blockRemark: ").append(toIndentedString(blockRemark)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
