package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 更新认证限额
 */
@ApiModel(description = "更新认证限额")

@JsonInclude(NON_NULL)
public class MsUpdateAuthQuotaRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("quota")
  private String quota = null;

  @JsonProperty("updateId")
  private Long updateId = null;

  @JsonProperty("updateName")
  private String updateName = null;

  @JsonIgnore
  public MsUpdateAuthQuotaRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 更新id
   * @return id
  **/
  @ApiModelProperty(value = "更新id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsUpdateAuthQuotaRequest quota(String quota) {
    this.quota = quota;
    return this;
  }

   /**
   * 认证限额
   * @return quota
  **/
  @ApiModelProperty(value = "认证限额")
  public String getQuota() {
    return quota;
  }

  public void setQuota(String quota) {
    this.quota = quota;
  }

  @JsonIgnore
  public MsUpdateAuthQuotaRequest updateId(Long updateId) {
    this.updateId = updateId;
    return this;
  }

   /**
   * 操作人id
   * @return updateId
  **/
  @ApiModelProperty(value = "操作人id")
  public Long getUpdateId() {
    return updateId;
  }

  public void setUpdateId(Long updateId) {
    this.updateId = updateId;
  }

  @JsonIgnore
  public MsUpdateAuthQuotaRequest updateName(String updateName) {
    this.updateName = updateName;
    return this;
  }

   /**
   * 操作人名称
   * @return updateName
  **/
  @ApiModelProperty(value = "操作人名称")
  public String getUpdateName() {
    return updateName;
  }

  public void setUpdateName(String updateName) {
    this.updateName = updateName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateAuthQuotaRequest updateAuthQuotaRequest = (MsUpdateAuthQuotaRequest) o;
    return Objects.equals(this.id, updateAuthQuotaRequest.id) &&
        Objects.equals(this.quota, updateAuthQuotaRequest.quota) &&
        Objects.equals(this.updateId, updateAuthQuotaRequest.updateId) &&
        Objects.equals(this.updateName, updateAuthQuotaRequest.updateName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, quota, updateId, updateName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateAuthQuotaRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    quota: ").append(toIndentedString(quota)).append("\n");
    sb.append("    updateId: ").append(toIndentedString(updateId)).append("\n");
    sb.append("    updateName: ").append(toIndentedString(updateName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
