package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 更新请求
 */
@ApiModel(description = "更新请求")

@JsonInclude(NON_NULL)
public class MsUpdateSimpleCollectionRequest {
  @JsonProperty("ratio")
  private String ratio = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonIgnore
  public MsUpdateSimpleCollectionRequest ratio(String ratio) {
    this.ratio = ratio;
    return this;
  }

   /**
   * 转出比例
   * @return ratio
  **/
  @ApiModelProperty(value = "转出比例")
  public String getRatio() {
    return ratio;
  }

  public void setRatio(String ratio) {
    this.ratio = ratio;
  }

  @JsonIgnore
  public MsUpdateSimpleCollectionRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsUpdateSimpleCollectionRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateSimpleCollectionRequest updateSimpleCollectionRequest = (MsUpdateSimpleCollectionRequest) o;
    return Objects.equals(this.ratio, updateSimpleCollectionRequest.ratio) &&
        Objects.equals(this.sysUserId, updateSimpleCollectionRequest.sysUserId) &&
        Objects.equals(this.sysUserName, updateSimpleCollectionRequest.sysUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ratio, sysUserId, sysUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateSimpleCollectionRequest {\n");
    
    sb.append("    ratio: ").append(toIndentedString(ratio)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
