package com.xforceplus.purconfig.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 用户信息
 */
@ApiModel(description = "用户信息")

@JsonInclude(NON_NULL)
public class MsUserInfo {
  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("orgIds")
  private List<Long> orgIds = new ArrayList<Long>();

  @JsonIgnore
  public MsUserInfo sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户ID
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户ID")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsUserInfo sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户姓名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户姓名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsUserInfo groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 用户所属集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "用户所属集团ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsUserInfo orgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
    return this;
  }

  public MsUserInfo addOrgIdsItem(Long orgIdsItem) {
    this.orgIds.add(orgIdsItem);
    return this;
  }

   /**
   * 所属组织ID数组
   * @return orgIds
  **/
  @ApiModelProperty(value = "所属组织ID数组")
  public List<Long> getOrgIds() {
    return orgIds;
  }

  public void setOrgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUserInfo userInfo = (MsUserInfo) o;
    return Objects.equals(this.sysUserId, userInfo.sysUserId) &&
        Objects.equals(this.sysUserName, userInfo.sysUserName) &&
        Objects.equals(this.groupId, userInfo.groupId) &&
        Objects.equals(this.orgIds, userInfo.orgIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sysUserId, sysUserName, groupId, orgIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUserInfo {\n");
    
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    orgIds: ").append(toIndentedString(orgIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
