package com.xforceplus.purconfig.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * Response object
 */
@ApiModel(description = "Response object")

@JsonInclude(NON_NULL)
public class Response<T> {
    @JsonProperty("code")
    private Integer code = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("result")
    private T result = null;

    @JsonIgnore
    public Response code(Integer code) {
        this.code = code;
        return this;
    }

    /**
     * return code
     *
     * @return code
     **/
    @ApiModelProperty(value = "return code")
    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @JsonIgnore
    public Response message(String message) {
        this.message = message;
        return this;
    }

    /**
     * return message
     *
     * @return message
     **/
    @ApiModelProperty(value = "return message")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public Response result(T result) {
        this.result = result;
        return this;
    }

    /**
     * result
     *
     * @return result
     **/
    @ApiModelProperty(value = "result ")
    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Response generalResponse = (Response) o;
        return Objects.equals(this.code, generalResponse.code) &&
                Objects.equals(this.message, generalResponse.message) &&
                Objects.equals(this.result, generalResponse.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeneralResponse {\n");

        sb.append("    code: ").append(toIndentedString(code)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
