package com.xforceplus.purconfig.client.model.config;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Describe: 配置项信息
 *
 * @Author xiezhongyong
 * @Date 2019/9/12
 * @Version 1.0
 */
@Data
public class ConfigitemBean {

    @ApiModelProperty(value = "配置组ID")
    private Long configGroupId;

    @ApiModelProperty(value = "配置名称")
    private String configGroupName;

    @ApiModelProperty(value = "配置组代码(区分不同配置组)")
    private String configGroupCode;

    @ApiModelProperty(value = "是否为默认配置(0:否,1:是)")
    private Integer defaultConfigFlag;

    @ApiModelProperty(value = "配置级别（0:默认集团配置；1：集团配置；2：企业配置）")
    private Integer configLevel;

    @ApiModelProperty(value = "购方名称(集团名称/企业名称)")
    private String purchaserName;

    @ApiModelProperty(value = "组织ID")
    private Long orgStructId;

    @ApiModelProperty(value = "集团ID")
    private Long groupId;

    @ApiModelProperty(value = "公司ID")
    private Long companyId;

    @ApiModelProperty(value = "购方纳税人识别号")
    private String purchaserTaxNo;

    @ApiModelProperty(value = "销方纳税人识别号")
    private String sellerTaxNo;

    @ApiModelProperty(value = "公司生效范围(0:集团,1:企业)")
    private Integer configGroupRange;

    @ApiModelProperty(value = "配置项ID")
    private Long configItemId;

    @ApiModelProperty(value = "配置项代码(区分不同规则)")
    private String configItemCode;

    @ApiModelProperty(value = "配置内容")
    private String configContent;


}
