package com.xforceplus.purconfig.client.model.config;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 配置接口列表 参数封装
 *
 * @Author xiezhongyong
 * @Date 2019/9/12
 * @Version 1.0
 */
@Data
public class ListConfigItemRequest {
    @ApiModelProperty(value = "集团ID")
    private Long groupId;

    @ApiModelProperty(value = "查询条件类型（公司id：COMPANYID / 公司税号：PURCHASERTAXNO）")
    private ConditionType conditionType;

    @ApiModelProperty(value = "公司ID列表")
    private List<Long> companyIds;

    @ApiModelProperty(value = "公司税号列表")
    private List<String> purchaserTaxNos;

    @ApiModelProperty(value = "配置项代码")
    private ConfigItemCodeEnum configItemCode;


    /**
     *  查询条件类型（公司id / 公司税号）
     */
    public static enum ConditionType{
        /** 公司ID*/
        COMPANYID,
        /** 公司税号*/
        PURCHASERTAXNO;
    }

}
